/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.maven;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

final class Protoc {
    private final String executable;
    private final ImmutableSet<File> protoPathElements;
    private final ImmutableSet<File> protoFiles;
    private final File javaOutputDirectory;
    private final CommandLineUtils.StringStreamConsumer output;
    private final CommandLineUtils.StringStreamConsumer error;

    private Protoc(String executable, ImmutableSet<File> protoPath, ImmutableSet<File> protoFiles, File javaOutputDirectory) {
        this.executable = (String)Preconditions.checkNotNull((Object)executable, (Object)"executable");
        this.protoPathElements = (ImmutableSet)Preconditions.checkNotNull(protoPath, (Object)"protoPath");
        this.protoFiles = (ImmutableSet)Preconditions.checkNotNull(protoFiles, (Object)"protoFiles");
        this.javaOutputDirectory = (File)Preconditions.checkNotNull((Object)javaOutputDirectory, (Object)"javaOutputDirectory");
        this.error = new CommandLineUtils.StringStreamConsumer();
        this.output = new CommandLineUtils.StringStreamConsumer();
    }

    public int compile() throws CommandLineException {
        Commandline cl = new Commandline();
        cl.setExecutable(this.executable);
        cl.addArguments((String[])this.buildProtocCommand().toArray((Object[])new String[0]));
        return CommandLineUtils.executeCommandLine((Commandline)cl, null, (StreamConsumer)this.output, (StreamConsumer)this.error);
    }

    ImmutableList<String> buildProtocCommand() {
        LinkedList command = Lists.newLinkedList();
        for (File protoPathElement : this.protoPathElements) {
            command.add("--proto_path=" + protoPathElement);
        }
        command.add("--java_out=" + this.javaOutputDirectory);
        for (File protoFile : this.protoFiles) {
            command.add(protoFile.toString());
        }
        return ImmutableList.copyOf((Collection)command);
    }

    public String getOutput() {
        return this.output.getOutput();
    }

    public String getError() {
        return this.error.getOutput();
    }

    static final class Builder {
        private final String executable;
        private final File javaOutputDirectory;
        private Set<File> protopathElements;
        private Set<File> protoFiles;

        public Builder(String executable, File javaOutputDirectory) {
            this.executable = (String)Preconditions.checkNotNull((Object)executable, (Object)"executable");
            this.javaOutputDirectory = (File)Preconditions.checkNotNull((Object)javaOutputDirectory);
            Preconditions.checkArgument((boolean)javaOutputDirectory.isDirectory());
            this.protoFiles = Sets.newHashSet();
            this.protopathElements = Sets.newHashSet();
        }

        public Builder addProtoFile(File protoFile) {
            Preconditions.checkNotNull((Object)protoFile);
            Preconditions.checkArgument((boolean)protoFile.isFile());
            Preconditions.checkArgument((boolean)protoFile.getName().endsWith(".proto"));
            this.checkProtoFileIsInProtopath(protoFile);
            this.protoFiles.add(protoFile);
            return this;
        }

        private void checkProtoFileIsInProtopath(File protoFile) {
            assert (protoFile.isFile());
            Preconditions.checkState((boolean)this.checkProtoFileIsInProtopathHelper(protoFile.getParentFile()));
        }

        private boolean checkProtoFileIsInProtopathHelper(File directory) {
            assert (directory.isDirectory());
            if (this.protopathElements.contains(directory)) {
                return true;
            }
            File parentDirectory = directory.getParentFile();
            return parentDirectory == null ? false : this.checkProtoFileIsInProtopathHelper(parentDirectory);
        }

        public Builder addProtoFiles(Iterable<File> protoFiles) {
            for (File protoFile : protoFiles) {
                this.addProtoFile(protoFile);
            }
            return this;
        }

        public Builder addProtoPathElement(File protopathElement) {
            Preconditions.checkNotNull((Object)protopathElement);
            Preconditions.checkArgument((boolean)protopathElement.isDirectory());
            this.protopathElements.add(protopathElement);
            return this;
        }

        public Builder addProtoPathElements(Iterable<File> protopathElements) {
            for (File protopathElement : protopathElements) {
                this.addProtoPathElement(protopathElement);
            }
            return this;
        }

        public Protoc build() {
            Preconditions.checkState((!this.protoFiles.isEmpty() ? 1 : 0) != 0);
            return new Protoc(this.executable, ImmutableSet.copyOf(this.protopathElements), ImmutableSet.copyOf(this.protoFiles), this.javaOutputDirectory);
        }
    }
}

