/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.maven;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.protobuf.maven.Protoc;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.RawInputStreamFacade;

abstract class AbstractProtocMojo
extends AbstractMojo {
    private static final String PROTO_FILE_SUFFIX = ".proto";
    private static final String DEFAULT_INCLUDES = "**/*.proto";
    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"})
    protected MavenProject project;
    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"})
    protected MavenProjectHelper projectHelper;
    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"})
    private String protocExecutable;
    private File[] additionalProtoPathElements = new File[0];
    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"})
    private File temporaryProtoFileDirectory;
    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"})
    private ArtifactRepository localRepository;
    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"})
    private boolean hashDependentPaths;
    private Set<String> includes = ImmutableSet.of((Object)"**/*.proto");
    private Set<String> excludes = ImmutableSet.of();
    private long staleMillis = 0L;
    private boolean checkStaleness = false;
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    AbstractProtocMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkParameters();
        File protoSourceRoot = this.getProtoSourceRoot();
        if (protoSourceRoot.exists()) {
            try {
                ImmutableSet<File> protoFiles = this.findProtoFilesInDirectory(protoSourceRoot);
                File outputDirectory = this.getOutputDirectory();
                ImmutableSet<File> outputFiles = this.findGeneratedFilesInDirectory(this.getOutputDirectory());
                if (protoFiles.isEmpty()) {
                    this.getLog().info((CharSequence)"No proto files to compile.");
                }
                if (this.checkStaleness && this.lastModified(protoFiles) + this.staleMillis < this.lastModified(outputFiles)) {
                    this.getLog().info((CharSequence)"Skipping compilation because target directory newer than sources.");
                    this.attachFiles();
                }
                ImmutableSet<File> derivedProtoPathElements = this.makeProtoPathFromJars(this.temporaryProtoFileDirectory, (Iterable<File>)this.getDependencyArtifactFiles());
                if (!outputDirectory.mkdirs()) {
                    throw new MojoExecutionException("Could not create directories");
                }
                FileUtils.cleanDirectory((File)outputDirectory);
                Protoc protoc = new Protoc.Builder(this.protocExecutable, outputDirectory).addProtoPathElement(protoSourceRoot).addProtoPathElements((Iterable<File>)derivedProtoPathElements).addProtoPathElements(Arrays.asList(this.additionalProtoPathElements)).addProtoFiles((Iterable<File>)protoFiles).build();
                int exitStatus = protoc.compile();
                if (exitStatus != 0) {
                    this.getLog().error((CharSequence)("protoc failed output: " + protoc.getOutput()));
                    this.getLog().error((CharSequence)("protoc failed error: " + protoc.getError()));
                    throw new MojoFailureException("protoc did not exit cleanly. Review output for more information.");
                }
                this.attachFiles();
            }
            catch (IOException e) {
                throw new MojoExecutionException("An IO error occured", (Exception)e);
            }
            catch (IllegalArgumentException e) {
                throw new MojoFailureException("protoc failed to execute because: " + e.getMessage(), (Throwable)e);
            }
            catch (CommandLineException e) {
                throw new MojoExecutionException("An error occurred while invoking protoc.", (Exception)((Object)e));
            }
        } else {
            this.getLog().info((CharSequence)String.format("%s does not exist. Review the configuration or consider disabling the plugin.", protoSourceRoot));
        }
    }

    ImmutableSet<File> findGeneratedFilesInDirectory(File directory) throws IOException {
        if (directory == null || !directory.isDirectory()) {
            return ImmutableSet.of();
        }
        List javaFilesInDirectory = FileUtils.getFiles((File)directory, (String)"**/*.java", null);
        return ImmutableSet.copyOf((Collection)javaFilesInDirectory);
    }

    private long lastModified(ImmutableSet<File> files) {
        long result = 0L;
        for (File file : files) {
            if (file.lastModified() <= result) continue;
            result = file.lastModified();
        }
        return result;
    }

    private void checkParameters() {
        Preconditions.checkNotNull((Object)this.project, (Object)"project");
        Preconditions.checkNotNull((Object)this.projectHelper, (Object)"projectHelper");
        Preconditions.checkNotNull((Object)this.protocExecutable, (Object)"protocExecutable");
        File protoSourceRoot = this.getProtoSourceRoot();
        Preconditions.checkNotNull((Object)protoSourceRoot);
        Preconditions.checkArgument((!protoSourceRoot.isFile() ? 1 : 0) != 0, (Object)"protoSourceRoot is a file, not a diretory");
        Preconditions.checkNotNull((Object)this.temporaryProtoFileDirectory, (Object)"temporaryProtoFileDirectory");
        Preconditions.checkState((!this.temporaryProtoFileDirectory.isFile() ? 1 : 0) != 0, (Object)"temporaryProtoFileDirectory is a file, not a directory");
        File outputDirectory = this.getOutputDirectory();
        Preconditions.checkNotNull((Object)outputDirectory);
        Preconditions.checkState((!outputDirectory.isFile() ? 1 : 0) != 0, (Object)"the outputDirectory is a file, not a directory");
    }

    protected abstract File getProtoSourceRoot();

    protected abstract List<Artifact> getDependencyArtifacts();

    protected abstract File getOutputDirectory();

    protected abstract void attachFiles();

    private ImmutableSet<File> getDependencyArtifactFiles() {
        HashSet dependencyArtifactFiles = Sets.newHashSet();
        for (Artifact artifact : this.getDependencyArtifacts()) {
            dependencyArtifactFiles.add(artifact.getFile());
        }
        return ImmutableSet.copyOf((Collection)dependencyArtifactFiles);
    }

    ImmutableSet<File> makeProtoPathFromJars(File temporaryProtoFileDirectory, Iterable<File> classpathElementFiles) throws IOException, MojoExecutionException {
        Preconditions.checkNotNull(classpathElementFiles, (Object)"classpathElementFiles");
        if (temporaryProtoFileDirectory.exists()) {
            FileUtils.cleanDirectory((File)temporaryProtoFileDirectory);
        }
        HashSet protoDirectories = Sets.newHashSet();
        for (File classpathElementFile : classpathElementFiles) {
            File[] protoFiles;
            if (classpathElementFile.isFile() && classpathElementFile.canRead() && !classpathElementFile.getName().endsWith(".xml")) {
                JarFile classpathJar = null;
                try {
                    classpathJar = new JarFile(classpathElementFile);
                    for (JarEntry jarEntry : Collections.list(classpathJar.entries())) {
                        String jarEntryName = jarEntry.getName();
                        if (!jarEntry.getName().endsWith(PROTO_FILE_SUFFIX)) continue;
                        File uncompressedCopy = new File(new File(temporaryProtoFileDirectory, this.truncatePath(classpathJar.getName())), jarEntryName);
                        if (!uncompressedCopy.getParentFile().mkdirs()) {
                            throw new MojoExecutionException("Could not create folders for " + uncompressedCopy.getParent());
                        }
                        FileUtils.copyStreamToFile((InputStreamFacade)new RawInputStreamFacade(classpathJar.getInputStream(jarEntry)), (File)uncompressedCopy);
                        protoDirectories.add(uncompressedCopy.getParentFile());
                    }
                    continue;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format("%s was not a readable artifact", classpathElementFile));
                }
                finally {
                    if (classpathJar != null) {
                        classpathJar.close();
                    }
                    continue;
                }
            }
            if (!classpathElementFile.isDirectory() || (protoFiles = classpathElementFile.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(AbstractProtocMojo.PROTO_FILE_SUFFIX);
                }
            })).length <= 0) continue;
            protoDirectories.add(classpathElementFile);
        }
        return ImmutableSet.copyOf((Collection)protoDirectories);
    }

    ImmutableSet<File> findProtoFilesInDirectory(File directory) throws IOException {
        Preconditions.checkNotNull((Object)directory);
        Preconditions.checkArgument((boolean)directory.isDirectory(), (String)"%s is not a directory", (Object[])new Object[]{directory});
        List protoFilesInDirectory = FileUtils.getFiles((File)directory, (String)Joiner.on((String)",").join(this.includes), (String)Joiner.on((String)",").join(this.excludes));
        return ImmutableSet.copyOf((Collection)protoFilesInDirectory);
    }

    ImmutableSet<File> findProtoFilesInDirectories(Iterable<File> directories) throws IOException {
        Preconditions.checkNotNull(directories);
        HashSet protoFiles = Sets.newHashSet();
        for (File directory : directories) {
            protoFiles.addAll(this.findProtoFilesInDirectory(directory));
        }
        return ImmutableSet.copyOf((Collection)protoFiles);
    }

    String truncatePath(String jarPath) throws MojoExecutionException {
        int colonIndex;
        String path;
        int repositoryIndex;
        if (this.hashDependentPaths) {
            try {
                return AbstractProtocMojo.toHexString(MessageDigest.getInstance("MD5").digest(jarPath.getBytes(Charsets.UTF_8)));
            }
            catch (NoSuchAlgorithmException e) {
                throw new MojoExecutionException("Failed to expand dependent jar", (Exception)e);
            }
        }
        String repository = this.localRepository.getBasedir().replace('\\', '/');
        if (!repository.endsWith("/")) {
            repository = repository + "/";
        }
        if ((repositoryIndex = (path = jarPath.replace('\\', '/')).indexOf(repository)) != -1) {
            path = path.substring(repositoryIndex + repository.length());
        }
        if ((colonIndex = path.indexOf(58)) != -1) {
            path = path.substring(colonIndex + 2);
        }
        return path;
    }

    public static String toHexString(byte[] byteArray) {
        StringBuilder hexString = new StringBuilder(2 * byteArray.length);
        for (byte b : byteArray) {
            hexString.append(HEX_CHARS[(b & 0xF0) >> 4]).append(HEX_CHARS[b & 0xF]);
        }
        return hexString.toString();
    }
}

