/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.jsonschema;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

enum SimpleTypeMappings {
    PRIMITIVE_BYTE(Byte.TYPE, "integer", ""),
    PRIMITIVE_SHORT(Short.TYPE, "integer", ""),
    PRIMITIVE_INTEGER(Integer.TYPE, "integer", ""),
    PRIMITIVE_LONG(Long.TYPE, "integer", ""),
    BYTE(Byte.class, "integer", ""),
    SHORT(Short.class, "integer", ""),
    INTEGER(Integer.class, "integer", ""),
    LONG(Long.class, "integer", ""),
    BIGINTEGER(BigInteger.class, "integer", ""),
    PRIMITIVE_FLOAT(Float.TYPE, "number", ""),
    PRIMITIVE_DOUBLE(Double.TYPE, "number", ""),
    FLOAT(Float.class, "number", ""),
    DOUBLE(Double.class, "number", ""),
    BIGDECIMAL(BigDecimal.class, "number", ""),
    PRIMITIVE_BOOLEAN(Boolean.TYPE, "boolean", ""),
    BOOLEAN(Boolean.class, "boolean", ""),
    PRIMITIVE_CHAR(Character.TYPE, "string", ""),
    CHAR(Character.class, "string", ""),
    CHARSEQUENCE(CharSequence.class, "string", ""),
    STRING(String.class, "string", ""),
    UUID(UUID.class, "string", "uuid"),
    URI(URI.class, "string", "uri"),
    ZONEDDATETIME(ZonedDateTime.class, "string", "date-time"),
    LOCALDATETIME(LocalDateTime.class, "string", "date-time"),
    OFFSETDATETIME(OffsetDateTime.class, "string", "date-time"),
    LOCALDATE(LocalDate.class, "string", "date"),
    LOCALTIME(LocalTime.class, "string", "time"),
    OFFSETTIME(OffsetTime.class, "string", "time"),
    DATE(Date.class, "string", "date-time"),
    INSTANT(Instant.class, "string", "date-time");

    private static final Class[] COLLECTION_CLASSES;
    private static final Map<Class<?>, String> TYPE_MAPPINGS;
    private static final Map<Class<?>, String> FORMAT_MAPPINGS;
    private final Class<?> c;
    private final String schemaType;
    private final String formatHint;

    private SimpleTypeMappings(Class<?> c, String schemaType, String formatHint) {
        this.c = c;
        this.schemaType = schemaType;
        this.formatHint = formatHint;
    }

    static Optional<String> forClass(Type type) {
        if (!(type instanceof Class)) {
            TypeToken token = TypeToken.of((Type)type);
            Class clazz = token.getRawType();
            if (Optional.class.isAssignableFrom(clazz)) {
                Preconditions.checkState((clazz.getTypeParameters().length > 0 ? 1 : 0) != 0, (Object)"No type arguments in return type found!");
                Type itemType = token.resolveType(clazz.getTypeParameters()[0]).getType();
                return SimpleTypeMappings.forClass(itemType);
            }
            return Optional.empty();
        }
        if (TYPE_MAPPINGS.containsKey(type)) {
            return Optional.of(TYPE_MAPPINGS.get(type));
        }
        return Optional.empty();
    }

    static Optional<String> formatHint(Type type) {
        if (!(type instanceof Class)) {
            return Optional.empty();
        }
        if (FORMAT_MAPPINGS.containsKey(type)) {
            return Optional.of(FORMAT_MAPPINGS.get(type));
        }
        return Optional.empty();
    }

    static boolean isCollectionLike(Type type) {
        TypeToken token = TypeToken.of((Type)type);
        for (Class collectionClass : COLLECTION_CLASSES) {
            if (!collectionClass.isAssignableFrom(token.getRawType())) continue;
            return true;
        }
        return false;
    }

    static {
        COLLECTION_CLASSES = new Class[]{Collection.class, Iterable.class};
        TYPE_MAPPINGS = new IdentityHashMap();
        FORMAT_MAPPINGS = new IdentityHashMap();
        for (SimpleTypeMappings mapping : SimpleTypeMappings.values()) {
            TYPE_MAPPINGS.put(mapping.c, mapping.schemaType);
            if (mapping.formatHint.isEmpty()) continue;
            FORMAT_MAPPINGS.put(mapping.c, mapping.formatHint);
        }
    }
}

