/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.jsonschema;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.google.common.base.Preconditions;
import de.softwareforge.jsonschema.JsonSchemaGenerator;
import de.softwareforge.jsonschema.JsonSchemaGeneratorConfiguration;
import java.util.function.Function;

public final class JsonSchemaGeneratorBuilder {
    private JsonSchemaGeneratorBuilder() {
    }

    public static JsonSchemaGeneratorConfigurationBuilder draftV4Schema() {
        return new JsonSchemaGeneratorConfigurationBuilder(JsonNodeFactory.instance, config -> new JsonSchemaGenerator((JsonSchemaGeneratorConfiguration)config));
    }

    public static class JsonSchemaGeneratorConfigurationBuilder {
        private final Function<JsonSchemaGeneratorConfiguration, JsonSchemaGenerator> factory;
        private final JsonSchemaGeneratorConfiguration.Builder builder;

        JsonSchemaGeneratorConfigurationBuilder(JsonNodeFactory nodeFactory, Function<JsonSchemaGeneratorConfiguration, JsonSchemaGenerator> factory) {
            this.factory = factory;
            this.builder = JsonSchemaGeneratorConfiguration.builder().customNodeFactory(nodeFactory);
        }

        public JsonSchemaGeneratorConfigurationBuilder removeSchemaVersion() {
            this.builder.removeSchemaVersion();
            return this;
        }

        public JsonSchemaGeneratorConfigurationBuilder disableSortSchemaProperties() {
            this.builder.disableSortSchemaProperties();
            return this;
        }

        public JsonSchemaGeneratorConfigurationBuilder disableProcessProperties() {
            this.builder.disableProcessProperties();
            return this;
        }

        public JsonSchemaGeneratorConfigurationBuilder processFields() {
            this.builder.processFields();
            return this;
        }

        public JsonSchemaGeneratorConfigurationBuilder customNodeFactory(JsonNodeFactory nodeFactory) {
            Preconditions.checkNotNull((Object)nodeFactory, (Object)"nodeFactory is null");
            this.builder.customNodeFactory(nodeFactory);
            return this;
        }

        public final JsonSchemaGenerator build() {
            return this.factory.apply(this.builder.build());
        }
    }
}

