/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.jsonschema;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import de.softwareforge.jsonschema.AutoValue_AttributeHolder;
import de.softwareforge.jsonschema.annotations.JsonSchema;
import de.softwareforge.jsonschema.annotations.Nullable;
import de.softwareforge.jsonschema.annotations.SchemaIgnore;
import de.softwareforge.jsonschema.annotations.SchemaIgnoreProperties;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Optional;
import java.util.OptionalInt;

@AutoValue
public abstract class AttributeHolder {
    public static Optional<AttributeHolder> locate(AnnotatedElement element) {
        Nullable nullable;
        SchemaIgnoreProperties schemaIgnoreProperties;
        SchemaIgnore schemaIgnore;
        JsonProperty jsonProperty;
        Preconditions.checkNotNull((Object)element, (Object)"element is null");
        Builder builder = AttributeHolder.builder();
        boolean foundAnnotations = false;
        JsonSchema jsonSchema = element.getAnnotation(JsonSchema.class);
        if (jsonSchema != null) {
            builder.attributes(jsonSchema);
            foundAnnotations = true;
        }
        if ((jsonProperty = element.getAnnotation(JsonProperty.class)) != null) {
            foundAnnotations = true;
            if (jsonProperty.required()) {
                builder.required(true);
            }
            if (!jsonProperty.value().isEmpty()) {
                builder.named(jsonProperty.value());
            }
        }
        if ((schemaIgnore = element.getAnnotation(SchemaIgnore.class)) != null) {
            foundAnnotations = true;
            builder.ignored(true);
        }
        if ((schemaIgnoreProperties = element.getAnnotation(SchemaIgnoreProperties.class)) != null) {
            foundAnnotations = true;
            builder.ignoredProperties(true);
        }
        if ((nullable = element.getAnnotation(Nullable.class)) != null) {
            foundAnnotations = true;
            builder.nullable(true);
        }
        return foundAnnotations ? Optional.of(builder.build()) : Optional.empty();
    }

    public static Builder builder() {
        return new AutoValue_AttributeHolder.Builder().exclusiveMaximum(false).exclusiveMinimum(false).required(false).uniqueItems(false).readonly(false).additionalProperties(true).ignored(false).ignoredProperties(false).nullable(false);
    }

    public abstract Optional<String> $ref();

    public abstract Optional<String> id();

    public abstract Optional<String> title();

    public abstract Optional<String> description();

    public abstract OptionalInt maximum();

    public abstract boolean exclusiveMaximum();

    public abstract OptionalInt minimum();

    public abstract boolean exclusiveMinimum();

    public abstract Optional<String> pattern();

    public abstract Optional<String> format();

    public abstract boolean required();

    public abstract ImmutableSet<String> enums();

    public abstract OptionalInt minItems();

    public abstract OptionalInt maxItems();

    public abstract boolean uniqueItems();

    public abstract OptionalInt multipleOf();

    public abstract OptionalInt minLength();

    public abstract OptionalInt maxLength();

    public abstract boolean readonly();

    public abstract boolean additionalProperties();

    public abstract boolean ignored();

    public abstract boolean ignoredProperties();

    public abstract boolean nullable();

    public abstract Optional<String> named();

    public abstract Optional<String> type();

    void augmentCommonAttributes(ObjectNode node) {
        this.id().ifPresent(id -> node.put("id", id));
        this.description().ifPresent(description -> node.put("description", description));
        this.pattern().ifPresent(pattern -> node.put("pattern", pattern));
        this.format().ifPresent(format -> node.put("format", format));
        this.title().ifPresent(title -> node.put("title", title));
        this.maximum().ifPresent(maximum -> node.put("maximum", maximum));
        if (this.exclusiveMaximum()) {
            node.put("exclusiveMaximum", true);
        }
        this.minimum().ifPresent(minimum -> node.put("minimum", minimum));
        if (this.exclusiveMinimum()) {
            node.put("exclusiveMinimum", true);
        }
        if (!this.enums().isEmpty()) {
            ArrayNode enumArray = node.putArray("enum");
            for (String v : this.enums()) {
                enumArray.add(v);
            }
        }
        if (this.uniqueItems()) {
            node.put("uniqueItems", true);
        }
        this.minItems().ifPresent(minItems -> node.put("minItems", minItems));
        this.maxItems().ifPresent(maxItems -> node.put("maxItems", maxItems));
        this.multipleOf().ifPresent(multipleOf -> node.put("multipleOf", multipleOf));
        this.minLength().ifPresent(minLength -> node.put("minLength", minLength));
        this.maxLength().ifPresent(maxLength -> node.put("maxLength", maxLength));
        if (this.readonly()) {
            node.put("readonly", true);
        }
    }

    public static abstract class Builder {
        public abstract Builder $ref(String var1);

        public abstract Builder id(String var1);

        public abstract Builder title(String var1);

        public abstract Builder description(String var1);

        public abstract Builder maximum(int var1);

        public abstract Builder exclusiveMaximum(boolean var1);

        public abstract Builder minimum(int var1);

        public abstract Builder exclusiveMinimum(boolean var1);

        public abstract Builder pattern(String var1);

        public abstract Builder format(String var1);

        public abstract Builder required(boolean var1);

        public abstract ImmutableSet.Builder<String> enumsBuilder();

        public Builder addEnum(String enumValue) {
            this.enumsBuilder().add((Object)enumValue);
            return this;
        }

        public abstract Builder minItems(int var1);

        public abstract Builder maxItems(int var1);

        public abstract Builder uniqueItems(boolean var1);

        public abstract Builder multipleOf(int var1);

        public abstract Builder minLength(int var1);

        public abstract Builder maxLength(int var1);

        public abstract Builder readonly(boolean var1);

        public abstract Builder additionalProperties(boolean var1);

        public abstract Builder ignored(boolean var1);

        public abstract Builder ignoredProperties(boolean var1);

        public abstract Builder nullable(boolean var1);

        public abstract Builder named(String var1);

        public abstract Builder type(String var1);

        public abstract AttributeHolder build();

        public Builder attributes(JsonSchema jsonSchema) {
            if (!jsonSchema.$ref().isEmpty()) {
                this.$ref(jsonSchema.$ref());
            }
            if (!jsonSchema.id().isEmpty()) {
                this.id(jsonSchema.id());
            }
            if (!jsonSchema.title().isEmpty()) {
                this.title(jsonSchema.title());
            }
            if (!jsonSchema.description().isEmpty()) {
                this.description(jsonSchema.description());
            }
            if (jsonSchema.maximum() >= 0) {
                this.maximum(jsonSchema.maximum());
            }
            this.exclusiveMaximum(jsonSchema.exclusiveMaximum());
            if (jsonSchema.minimum() >= 0) {
                this.minimum(jsonSchema.minimum());
            }
            this.exclusiveMinimum(jsonSchema.exclusiveMinimum());
            if (!jsonSchema.pattern().isEmpty()) {
                this.pattern(jsonSchema.pattern());
            }
            if (!jsonSchema.format().isEmpty()) {
                this.format(jsonSchema.format());
            }
            this.required(jsonSchema.required());
            this.enumsBuilder().addAll(Arrays.asList(jsonSchema.enums()));
            if (jsonSchema.minItems() > 0) {
                this.minItems(jsonSchema.minItems());
            }
            if (jsonSchema.maxItems() >= 0) {
                this.maxItems(jsonSchema.maxItems());
            }
            this.uniqueItems(jsonSchema.uniqueItems());
            if (jsonSchema.multipleOf() > 0) {
                this.multipleOf(jsonSchema.multipleOf());
            }
            if (jsonSchema.minLength() > 0) {
                this.minLength(jsonSchema.minLength());
            }
            if (jsonSchema.maxLength() >= 0) {
                this.maxLength(jsonSchema.maxLength());
            }
            this.readonly(jsonSchema.readonly());
            this.additionalProperties(jsonSchema.additionalProperties());
            if (!jsonSchema.type().isEmpty()) {
                this.type(jsonSchema.type());
            }
            return this;
        }
    }
}

