/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.jsonschema.inheritance;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.softwareforge.jsonschema.JsonSchemaGenerator;
import de.softwareforge.jsonschema.JsonSchemaGeneratorBuilder;
import de.softwareforge.jsonschema.TestUtility;
import de.softwareforge.jsonschema.inheritance.CollegeStudent;
import de.softwareforge.jsonschema.inheritance.MusicItem;
import de.softwareforge.jsonschema.inheritance.WarrantyItem;
import org.junit.Test;

public class InheritanceTest {
    private final JsonSchemaGenerator schemaGenerator = JsonSchemaGeneratorBuilder.draftV4Schema().build();

    @Test
    public void testGenerateSchema() throws JsonProcessingException {
        ObjectNode schema = TestUtility.generateSchema(this.schemaGenerator, MusicItem.class);
        TestUtility.testProperties(schema, "artistName", "releaseYear", "price");
        schema = TestUtility.generateSchema(this.schemaGenerator, WarrantyItem.class);
        TestUtility.testProperties(schema, "type", "termsAndConditionsAccepted", "contractTermInMonths");
    }

    @Test
    public void testInheritedProperties() throws JsonProcessingException {
        ObjectNode schema = TestUtility.generateSchema(this.schemaGenerator, CollegeStudent.class);
        ObjectNode properties = TestUtility.testWithProperties(schema, "name", "major");
        TestUtility.testPropertyAttribute(properties, "name", "description", "student name");
        TestUtility.testRequired(schema, "major", "name");
    }
}

