/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.jsonschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Streams;
import de.softwareforge.jsonschema.JsonSchemaGenerator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.Assert;
import org.junit.Ignore;

@Ignore
public final class TestUtility {
    private TestUtility() {
        throw new AssertionError();
    }

    public static ObjectNode generateSchema(JsonSchemaGenerator generator, Class<?> testClass) {
        return generator.generateSchema(testClass);
    }

    public static Optional<ObjectNode> testProperties(ObjectNode schema, String ... expectedFields) {
        if (expectedFields.length == 0) {
            Assert.assertFalse((String)"unexpected properties attribute found", (boolean)schema.has("properties"));
            return Optional.empty();
        }
        Assert.assertTrue((String)"no properties attribute found", (boolean)schema.has("properties"));
        JsonNode child = schema.get("properties");
        Assert.assertTrue((String)"properties is not an object", (boolean)child.isObject());
        ObjectNode properties = (ObjectNode)child;
        Assert.assertEquals((String)"number of properties does not match", (long)expectedFields.length, (long)properties.size());
        for (String field : expectedFields) {
            Assert.assertTrue((String)("No field '" + field + "' found!"), (boolean)properties.has(field));
        }
        return Optional.of(properties);
    }

    public static ObjectNode testWithProperties(ObjectNode schema, String firstField, String ... expectedFields) {
        String[] fields = new String[expectedFields.length + 1];
        fields[0] = firstField;
        System.arraycopy(expectedFields, 0, fields, 1, expectedFields.length);
        Optional<ObjectNode> schemaHolder = TestUtility.testProperties(schema, fields);
        Assert.assertTrue((String)"no properties found", (boolean)schemaHolder.isPresent());
        return schemaHolder.get();
    }

    public static void testRequired(ObjectNode schema, String ... expectedFields) {
        if (expectedFields.length == 0) {
            Assert.assertFalse((String)"unexpected required attribute found", (boolean)schema.has("required"));
        } else {
            Assert.assertTrue((String)"no required attribute found", (boolean)schema.has("required"));
            JsonNode child = schema.get("required");
            Assert.assertTrue((String)"required is not an array", (boolean)child.isArray());
            ArrayNode required = (ArrayNode)child;
            Assert.assertEquals((String)"number of elements in required field does not match", (long)expectedFields.length, (long)required.size());
            Object[] values = new String[required.size()];
            for (int i = 0; i < expectedFields.length; ++i) {
                values[i] = required.get(i).asText();
            }
            Assert.assertThat((String)"required values do not match", Arrays.asList(expectedFields), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])values));
        }
    }

    public static void testEnumValues(ObjectNode schema, String property, Object ... expectedValues) {
        Assert.assertTrue((String)("property '" + property + "' not present"), (boolean)schema.has(property));
        JsonNode child = schema.get(property);
        Assert.assertTrue((String)("'" + property + "' is not an object"), (boolean)child.isObject());
        ObjectNode propertyNode = (ObjectNode)child;
        Assert.assertTrue((String)("'" + property + "' is not an enum"), (boolean)propertyNode.has("enum"));
        child = propertyNode.get("enum");
        Assert.assertTrue((String)"'enum' is not an array", (boolean)child.isArray());
        ArrayNode enumNode = (ArrayNode)child;
        Assert.assertEquals((String)"number of elements in enum does not match", (long)expectedValues.length, (long)enumNode.size());
        Object[] values = new Object[enumNode.size()];
        for (int i = 0; i < expectedValues.length; ++i) {
            JsonNode node = enumNode.get(i);
            values[i] = node.isNumber() ? node.numberValue() : (node.isBoolean() ? Boolean.valueOf(node.booleanValue()) : (node.isNull() ? null : node.asText()));
        }
        Assert.assertThat((String)"enum values do not match", Arrays.asList(expectedValues), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])values));
    }

    public static void testPropertyAttribute(ObjectNode schema, String property, String attribute, Object ... values) {
        Assert.assertTrue((String)("property '" + property + "' not present"), (boolean)schema.has(property));
        JsonNode child = schema.get(property);
        Assert.assertTrue((String)("'" + property + "' is not an object"), (boolean)child.isObject());
        ObjectNode propertyNode = (ObjectNode)child;
        if (values.length == 0) {
            if (!propertyNode.has(attribute)) {
                return;
            }
            JsonNode attributeNode = propertyNode.get(attribute);
            if (attributeNode.isArray() || ((ArrayNode)attributeNode).size() == 0) {
                return;
            }
            Assert.fail((String)("property attribute '" + property + "." + attribute + "' present."));
        } else {
            Assert.assertTrue((String)("attribute '" + property + "." + attribute + "' not present"), (boolean)propertyNode.has(attribute));
            JsonNode attributeNode = propertyNode.get(attribute);
            if (values.length == 1) {
                if (attributeNode.isArray()) {
                    if (attributeNode.size() != 1) {
                        Assert.fail((String)("property attribute '" + property + "." + attribute + "' must have a single value"));
                    }
                    attributeNode = attributeNode.get(0);
                }
                Object value = values[0];
                Object attributeValue = TestUtility.fetchAttributeValue(attributeNode);
                Assert.assertEquals((Object)value, (Object)attributeValue);
            } else {
                Assert.assertTrue((String)("attribute '" + property + "." + attribute + "' not an array"), (boolean)attributeNode.isArray());
                Object[] attributeValues = new Object[values.length];
                for (int i = 0; i < values.length; ++i) {
                    attributeValues[i] = TestUtility.fetchAttributeValue(attributeNode.get(i));
                }
                Assert.assertArrayEquals((Object[])values, (Object[])attributeValues);
            }
        }
    }

    private static Object fetchAttributeValue(JsonNode valueNode) {
        if (valueNode.isNull()) {
            return null;
        }
        if (valueNode.isBoolean()) {
            return valueNode.booleanValue();
        }
        if (valueNode.isNumber()) {
            return valueNode.numberValue();
        }
        if (valueNode.isTextual()) {
            return valueNode.textValue();
        }
        if (valueNode.isArray()) {
            return Streams.stream((Iterator)valueNode.iterator()).collect(Collectors.toList());
        }
        if (valueNode.isObject()) {
            return Streams.stream((Iterator)valueNode.fields()).collect(Collectors.toMap(Map.Entry::getKey, value -> TestUtility.fetchAttributeValue((JsonNode)value.getValue())));
        }
        Assert.fail((String)("Unknown node type: " + valueNode));
        return null;
    }

    public static void testPropertyType(ObjectNode schema, String property, Object ... values) {
        TestUtility.testPropertyAttribute(schema, property, "type", values);
    }
}

