/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.jsonschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.softwareforge.jsonschema.JsonSchemaGenerator;
import de.softwareforge.jsonschema.JsonSchemaGeneratorBuilder;
import de.softwareforge.jsonschema.annotations.JsonSchema;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;

public class SimpleTest {
    private final JsonSchemaGenerator schemaGenerator = JsonSchemaGeneratorBuilder.draftV4Schema().removeSchemaVersion().build();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Test
    public void testGenerateSchema() throws Exception {
        InputStream in = SimpleTest.class.getResourceAsStream("/simple_example.json");
        Assert.assertNotNull((String)"stream not found", (Object)in);
        JsonNode fromResource = MAPPER.readTree(in);
        ObjectNode fromJavaType = this.schemaGenerator.generateSchema(SimpleExample.class);
        Assert.assertEquals((Object)fromResource, (Object)fromJavaType);
    }

    @JsonSchema(title="Example Schema")
    static class SimpleExample {
        private String firstName;
        private String lastName;
        private int age;

        SimpleExample() {
        }

        @JsonSchema(required=true)
        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @JsonSchema(required=true)
        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @JsonSchema(description="Age in years", minimum=0)
        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }
    }
}

