/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.jsonschema;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.softwareforge.jsonschema.JsonSchemaGenerator;
import de.softwareforge.jsonschema.JsonSchemaGeneratorBuilder;
import de.softwareforge.jsonschema.TestUtility;
import de.softwareforge.jsonschema.annotations.SchemaIgnore;
import java.util.List;
import org.junit.Test;

public class SchemaIgnoreTest {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final JsonSchemaGenerator schemaGenerator = JsonSchemaGeneratorBuilder.draftV4Schema().build();

    @Test
    public void testGenerateSaleSchema() {
        ObjectNode schema = this.schemaGenerator.generateSchema(Sale.class);
        TestUtility.testWithProperties(schema, "id", new String[0]);
    }

    public void testGenerateSaleItemSchema() {
        ObjectNode schema = this.schemaGenerator.generateSchema(SaleItem.class);
        TestUtility.testWithProperties(schema, "idSale", "seqNumber");
    }

    static class SaleItem {
        int idSale;
        int seqNumber;
        Sale parent;

        SaleItem() {
        }

        @JsonProperty
        public int getIdSale() {
            return this.idSale;
        }

        public void setIdSale(int idSale) {
            this.idSale = idSale;
        }

        @JsonProperty
        public int getSeqNumber() {
            return this.seqNumber;
        }

        public void setSeqNumber(int seqNumber) {
            this.seqNumber = seqNumber;
        }

        @SchemaIgnore
        @JsonProperty
        public Sale getParent() {
            return this.parent;
        }

        public void setParent(Sale parent) {
            this.parent = parent;
        }
    }

    static class Sale {
        int id;
        List<SaleItem> saleItems;

        Sale() {
        }

        @JsonProperty
        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        @SchemaIgnore
        @JsonProperty
        public List<SaleItem> getSaleItems() {
            return this.saleItems;
        }

        public void setSaleItems(List<SaleItem> saleItems) {
            this.saleItems = saleItems;
        }
    }
}

