/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.jsonschema;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.softwareforge.jsonschema.JsonSchemaGenerator;
import de.softwareforge.jsonschema.JsonSchemaGeneratorBuilder;
import de.softwareforge.jsonschema.TestUtility;
import de.softwareforge.jsonschema.annotations.SchemaIgnoreProperties;
import org.junit.Assert;
import org.junit.Test;

public class SchemaIgnorePropertiesTest {
    private final JsonSchemaGenerator schemaGenerator = JsonSchemaGeneratorBuilder.draftV4Schema().build();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Test
    public void testGenerateSchema() throws JsonProcessingException {
        ObjectNode schema = this.schemaGenerator.generateSchema(ItemWrapper.class);
        ObjectNode properties = TestUtility.testWithProperties(schema, "id", "item");
        TestUtility.testPropertyType(properties, "item", "object");
        ObjectNode itemNode = (ObjectNode)properties.get("item");
        Assert.assertFalse((boolean)itemNode.has("properties"));
    }

    static class Item {
        int itemId;
        String itemName;

        Item() {
        }

        @JsonProperty
        public int getItemId() {
            return this.itemId;
        }

        public void setItemId(int itemId) {
            this.itemId = itemId;
        }

        @JsonProperty
        public String getItemName() {
            return this.itemName;
        }

        public void setItemName(String itemName) {
            this.itemName = itemName;
        }
    }

    static class ItemWrapper {
        int id;
        Item item;

        ItemWrapper() {
        }

        @JsonProperty
        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        @SchemaIgnoreProperties
        public Item getItem() {
            return this.item;
        }

        public void setItem(Item item) {
            this.item = item;
        }
    }
}

