/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.jsonschema;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.softwareforge.jsonschema.JsonSchemaGenerator;
import de.softwareforge.jsonschema.JsonSchemaGeneratorBuilder;
import de.softwareforge.jsonschema.TestUtility;
import de.softwareforge.jsonschema.annotations.JsonSchema;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class ProductTest {
    private final JsonSchemaGenerator schemaGenerator = JsonSchemaGeneratorBuilder.draftV4Schema().build();
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ObjectWriter om = MAPPER.writerWithDefaultPrettyPrinter();

    @Test
    public void testProductSchema() throws Exception {
        InputStream in = ProductTest.class.getResourceAsStream("/product_schema.json");
        Assert.assertNotNull((String)"stream not found", (Object)in);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode fromFile = mapper.readTree(in);
        ObjectNode productSchema = TestUtility.generateSchema(this.schemaGenerator, Product.class);
        Assert.assertEquals((Object)fromFile, (Object)productSchema);
    }

    @JsonSchema(title="Product set")
    static class ProductSet
    implements Iterable<ComplexProduct> {
        private Set<ComplexProduct> products;

        public ProductSet(Set<ComplexProduct> products) {
            this.products = products;
        }

        @Override
        public Iterator<ComplexProduct> iterator() {
            return this.products.iterator();
        }
    }

    @JsonSchema($ref="http://json-schema.org/geo", description="A geographical coordinate")
    static class Geo {
        private BigDecimal latitude;
        private BigDecimal longitude;

        Geo() {
        }

        @JsonProperty
        public BigDecimal getLatitude() {
            return this.latitude;
        }

        public void setLatitude(BigDecimal latitude) {
            this.latitude = latitude;
        }

        @JsonProperty
        public BigDecimal getLongitude() {
            return this.longitude;
        }

        public void setLongitude(BigDecimal longitude) {
            this.longitude = longitude;
        }
    }

    static class Dimension {
        private double length;
        private double width;
        private double height;

        Dimension() {
        }

        @JsonSchema(required=true)
        public double getLength() {
            return this.length;
        }

        public void setLength(double length) {
            this.length = length;
        }

        @JsonSchema(required=true)
        public double getWidth() {
            return this.width;
        }

        public void setWidth(double width) {
            this.width = width;
        }

        @JsonSchema(required=true)
        public double getHeight() {
            return this.height;
        }

        public void setHeight(double height) {
            this.height = height;
        }
    }

    static class ComplexProduct
    extends Product {
        private Dimension dimensions;
        private Geo warehouseLocation;

        ComplexProduct() {
        }

        @JsonProperty
        public Dimension getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(Dimension dimensions) {
            this.dimensions = dimensions;
        }

        @JsonSchema(description="Coordinates of the warehouse with the product")
        public Geo getWarehouseLocation() {
            return this.warehouseLocation;
        }

        public void setWarehouseLocation(Geo warehouseLocation) {
            this.warehouseLocation = warehouseLocation;
        }
    }

    @JsonSchema(title="Product", description="A product from Acme's catalog")
    static class Product {
        private long id;
        private String name;
        private BigDecimal price;
        private List<String> tags;

        Product() {
        }

        @JsonSchema(required=true, description="The unique identifier for a product")
        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        @JsonSchema(required=true, description="Name of the product")
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @JsonSchema(required=true, minimum=0, exclusiveMinimum=true)
        public BigDecimal getPrice() {
            return this.price;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        @JsonSchema(minItems=1, uniqueItems=true)
        public List<String> getTags() {
            return this.tags;
        }

        public void setTags(List<String> tags) {
            this.tags = tags;
        }
    }
}

