/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.jsonschema;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.softwareforge.jsonschema.JsonSchemaGenerator;
import de.softwareforge.jsonschema.JsonSchemaGeneratorBuilder;
import de.softwareforge.jsonschema.TestUtility;
import de.softwareforge.jsonschema.annotations.Nullable;
import java.util.List;
import org.junit.Test;

public class NullableArrayTest {
    private final JsonSchemaGenerator schemaGenerator = JsonSchemaGeneratorBuilder.draftV4Schema().build();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Test
    public void testGenerateSchema() {
        ObjectNode schema = TestUtility.generateSchema(this.schemaGenerator, Something.class);
        ObjectNode properties = TestUtility.testWithProperties(schema, "id", "names");
        TestUtility.testPropertyType(properties, "names", "array", "null");
    }

    static class Something {
        private int id;
        private List<String> names;

        Something() {
        }

        @JsonProperty
        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        @Nullable
        @JsonProperty
        public List<String> getNames() {
            return this.names;
        }

        public void setNames(List<String> names) {
            this.names = names;
        }
    }
}

