/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.jsonschema;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.softwareforge.jsonschema.JsonSchemaGenerator;
import de.softwareforge.jsonschema.JsonSchemaGeneratorBuilder;
import de.softwareforge.jsonschema.TestUtility;
import de.softwareforge.jsonschema.annotations.JsonSchema;
import de.softwareforge.jsonschema.annotations.Nullable;
import java.time.Instant;
import org.junit.Test;

public class InterfaceTest {
    private final JsonSchemaGenerator schemaGenerator = JsonSchemaGeneratorBuilder.draftV4Schema().build();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Test
    public void testGenerateSchema() throws Exception {
        ObjectNode fromJavaType = TestUtility.generateSchema(this.schemaGenerator, UserInterface.class);
        ObjectNode properties = TestUtility.testWithProperties(fromJavaType, "birthday", "id", "name", "photo", "sex");
        TestUtility.testPropertyType(properties, "id", "integer");
        TestUtility.testPropertyAttribute(properties, "id", "title", "ID");
        TestUtility.testPropertyAttribute(properties, "id", "minimum", 100000);
        TestUtility.testPropertyAttribute(properties, "id", "maximum", 999999);
        TestUtility.testPropertyType(properties, "name", "string");
        TestUtility.testPropertyAttribute(properties, "name", "description", "User's name");
        TestUtility.testPropertyType(properties, "sex", "string", "null");
        TestUtility.testEnumValues(properties, "sex", "M", "F", null);
        TestUtility.testPropertyType(properties, "photo", "object", "null");
        TestUtility.testPropertyAttribute(properties, "photo", "description", "User's personal photo");
        TestUtility.testPropertyType(properties, "birthday", "string");
        TestUtility.testPropertyAttribute(properties, "birthday", "format", "date-time");
        TestUtility.testRequired(fromJavaType, "id", "name");
    }

    static interface UserInterface {
        @JsonSchema(required=true, title="ID", minimum=100000, maximum=999999)
        public short getId();

        public void setId(short var1);

        @JsonSchema(required=true, description="User's name")
        public String getName();

        public void setName(String var1);

        @JsonSchema(description="User's sex", enums={"M", "F"})
        @Nullable
        public char getSex();

        public void setSex(char var1);

        @JsonSchema(description="User's personal photo")
        @Nullable
        public Byte[] getPhoto();

        public void setPhoto(Byte[] var1);

        @JsonSchema(format="date-time")
        public Instant getBirthday();
    }
}

