/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.jsonschema;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.softwareforge.jsonschema.JsonSchemaGenerator;
import de.softwareforge.jsonschema.JsonSchemaGeneratorBuilder;
import de.softwareforge.jsonschema.SimpleExampleTest;
import de.softwareforge.jsonschema.TestUtility;
import java.io.InputStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class GenericsTest {
    private final JsonSchemaGenerator schemaGenerator = JsonSchemaGeneratorBuilder.draftV4Schema().removeSchemaVersion().build();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Test
    public void testGenerateSchema() throws Exception {
        InputStream in = SimpleExampleTest.class.getResourceAsStream("/generics_example.json");
        Assert.assertNotNull((String)"stream not found", (Object)in);
        JsonNode fromResource = MAPPER.readTree(in);
        ObjectNode fromJavaType = TestUtility.generateSchema(this.schemaGenerator, GenericExample.class);
        Assert.assertEquals((Object)fromResource, (Object)fromJavaType);
    }

    static class GenericExample {
        private Tuple<String, Integer> tuple;
        private List<Tuple<String, Boolean>> listOfTuples;

        GenericExample() {
        }

        @JsonProperty
        public Tuple<String, Integer> getTuple() {
            return this.tuple;
        }

        public void setTuple(Tuple<String, Integer> tuple) {
            this.tuple = tuple;
        }

        @JsonProperty
        public List<Tuple<String, Boolean>> getListOfTuples() {
            return this.listOfTuples;
        }

        public void setListOfTuples(List<Tuple<String, Boolean>> listOfTuples) {
            this.listOfTuples = listOfTuples;
        }
    }

    static class Tuple<A, B> {
        private A first;
        private B second;

        Tuple() {
        }

        @JsonProperty
        public A getFirst() {
            return this.first;
        }

        @JsonProperty
        public B getSecond() {
            return this.second;
        }

        public void setFirst(A a) {
            this.first = a;
        }

        public void setSecond(B b) {
            this.second = b;
        }
    }
}

