/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.jsonschema;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.softwareforge.jsonschema.JsonSchemaGenerator;
import de.softwareforge.jsonschema.JsonSchemaGeneratorBuilder;
import de.softwareforge.jsonschema.TestUtility;
import de.softwareforge.jsonschema.annotations.JsonSchema;
import java.time.Instant;
import org.junit.Before;
import org.junit.Test;

public class FormatTest {
    private ObjectNode properties;

    @Before
    public void setUp() throws Exception {
        JsonSchemaGenerator generator = JsonSchemaGeneratorBuilder.draftV4Schema().build();
        ObjectNode schema = TestUtility.generateSchema(generator, TestClass.class);
        this.properties = TestUtility.testWithProperties(schema, "hinted", "formatted", "overridden", "vanilla");
    }

    @Test
    public void testFormattingHinted() {
        TestUtility.testPropertyType(this.properties, "hinted", "string");
        TestUtility.testPropertyAttribute(this.properties, "hinted", "format", "date-time");
    }

    @Test
    public void testFormattingFormatted() {
        TestUtility.testPropertyType(this.properties, "formatted", "string");
        TestUtility.testPropertyAttribute(this.properties, "formatted", "format", "weird");
    }

    @Test
    public void testFormattingOverridden() {
        TestUtility.testPropertyType(this.properties, "overridden", "string");
        TestUtility.testPropertyAttribute(this.properties, "overridden", "format", "very-weird");
    }

    @Test
    public void testFormattingVanilla() {
        TestUtility.testPropertyType(this.properties, "vanilla", "string");
        TestUtility.testPropertyAttribute(this.properties, "vanilla", "format", new Object[0]);
    }

    public static interface TestClass {
        @JsonProperty
        public Instant getHinted();

        @JsonSchema(format="weird")
        public String getFormatted();

        @JsonSchema(format="very-weird")
        public Instant getOverridden();

        @JsonProperty
        public String getVanilla();
    }
}

