/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.jsonschema;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.softwareforge.jsonschema.JsonSchemaGenerator;
import de.softwareforge.jsonschema.JsonSchemaGeneratorBuilder;
import de.softwareforge.jsonschema.TestUtility;
import de.softwareforge.jsonschema.annotations.JsonSchema;
import de.softwareforge.jsonschema.annotations.Nullable;
import java.io.IOException;
import java.math.BigDecimal;
import org.junit.Test;

public class EnumTest {
    private final JsonSchemaGenerator schemaGenerator = JsonSchemaGeneratorBuilder.draftV4Schema().build();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Test
    public void testGenerateSchema() throws IOException {
        ObjectNode schema = TestUtility.generateSchema(this.schemaGenerator, Hyperthing.class);
        ObjectNode properties = TestUtility.testWithProperties(schema, "method", "resultCode", "floatingResultCode", "result");
        TestUtility.testEnumValues(properties, "method", "GET", "POST", "PUT", "DELETE");
        TestUtility.testEnumValues(properties, "resultCode", 404L, 401L);
        TestUtility.testEnumValues(properties, "floatingResultCode", new BigDecimal("4.04"), new BigDecimal("4.01"));
        TestUtility.testEnumValues(properties, "result", "NOT_FOUND", "UNAUTHORIZED", null);
    }

    static class Hyperthing {
        private String method;
        private IntegerEnum resultCode;
        private FloatingEnum floatingResultCode;
        private SimpleEnum result;

        Hyperthing() {
        }

        @JsonSchema(enums={"GET", "POST", "PUT", "DELETE"})
        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        @JsonProperty
        public IntegerEnum getResultCode() {
            return this.resultCode;
        }

        public void setResultCode(IntegerEnum resultCode) {
            this.resultCode = resultCode;
        }

        @JsonProperty
        public FloatingEnum getFloatingResultCode() {
            return this.floatingResultCode;
        }

        public void setFloatingResultCode(FloatingEnum floatingResultCode) {
            this.floatingResultCode = floatingResultCode;
        }

        @Nullable
        public SimpleEnum getResult() {
            return this.result;
        }

        public void setResult(SimpleEnum result) {
            this.result = result;
        }
    }

    public static enum SimpleEnum {
        NOT_FOUND,
        UNAUTHORIZED;

    }

    public static enum FloatingEnum {
        NOT_FOUND(4.04),
        UNAUTHORIZED(4.01);

        private double numVal;

        private FloatingEnum(double numVal) {
            this.numVal = numVal;
        }

        public double getNumVal() {
            return this.numVal;
        }

        public String toString() {
            return String.valueOf(this.numVal);
        }
    }

    public static enum IntegerEnum {
        NOT_FOUND(404),
        UNAUTHORIZED(401);

        private int numVal;

        private IntegerEnum(int numVal) {
            this.numVal = numVal;
        }

        public int getNumVal() {
            return this.numVal;
        }

        public String toString() {
            return String.valueOf(this.numVal);
        }
    }
}

