/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.jsonschema;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.softwareforge.jsonschema.JsonSchemaGenerator;
import de.softwareforge.jsonschema.JsonSchemaGeneratorBuilder;
import de.softwareforge.jsonschema.TestUtility;
import de.softwareforge.jsonschema.annotations.JsonSchema;
import org.junit.Test;

public class EmployeeTest {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final JsonSchemaGenerator schemaGenerator = JsonSchemaGeneratorBuilder.draftV4Schema().build();
    private final ObjectWriter ow = MAPPER.writerWithDefaultPrettyPrinter();

    @Test
    public void testEmployeeSchema() throws Exception {
        ObjectNode employeeSchema = TestUtility.generateSchema(this.schemaGenerator, Employee.class);
        TestUtility.testRequired(employeeSchema, "name");
        ObjectNode properties = TestUtility.testWithProperties(employeeSchema, "name", "retired");
        TestUtility.testPropertyType(properties, "name", "string");
        TestUtility.testPropertyAttribute(properties, "name", "description", "Name");
        TestUtility.testPropertyAttribute(properties, "name", "minLength", 5);
        TestUtility.testPropertyAttribute(properties, "name", "maxLength", 50);
        TestUtility.testPropertyType(properties, "retired", "boolean");
    }

    static class Employee {
        private String name;
        private boolean retired;

        Employee() {
        }

        @JsonSchema(required=true, minLength=5, maxLength=50, description="Name")
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public boolean isRetired() {
            return this.retired;
        }

        public void setRetired(boolean retired) {
            this.retired = retired;
        }
    }
}

