/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.jsonschema;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.softwareforge.jsonschema.JsonSchemaGenerator;
import de.softwareforge.jsonschema.JsonSchemaGeneratorBuilder;
import de.softwareforge.jsonschema.TestUtility;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class BugsTest {
    private final JsonSchemaGenerator schemaGenerator = JsonSchemaGeneratorBuilder.draftV4Schema().build();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Test
    public void testNameBug() throws Exception {
        ObjectNode schema = TestUtility.generateSchema(this.schemaGenerator, NameBug.class);
        TestUtility.testWithProperties(schema, "value", new String[0]);
    }

    @Test
    public void testPropertyBug() throws Exception {
        ObjectNode schema = TestUtility.generateSchema(this.schemaGenerator, PropertyBug.class);
        TestUtility.testWithProperties(schema, "xxx", new String[0]);
    }

    @Test
    public void testOptionalBug() throws Exception {
        ObjectNode schema = TestUtility.generateSchema(this.schemaGenerator, OptionalBug.class);
        ObjectNode properties = TestUtility.testWithProperties(schema, "optionalString", "optionalInteger");
        Assert.assertEquals((Object)"string", (Object)properties.path("optionalString").path("type").asText());
        Assert.assertEquals((Object)"integer", (Object)properties.path("optionalInteger").path("type").asText());
    }

    public static class OptionalBug {
        @JsonProperty
        public Optional<String> optionalString() {
            return Optional.empty();
        }

        @JsonProperty
        public Optional<Integer> optionalInteger() {
            return Optional.empty();
        }
    }

    public static class PropertyBug {
        @JsonProperty
        public String xxx() {
            return "1";
        }
    }

    public static class NameBug {
        @JsonProperty(value="value")
        public String value() {
            return "1";
        }
    }
}

