/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.jsonschema;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.softwareforge.jsonschema.JsonSchemaGenerator;
import de.softwareforge.jsonschema.JsonSchemaGeneratorBuilder;
import de.softwareforge.jsonschema.TestUtility;
import de.softwareforge.jsonschema.annotations.JsonSchema;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class AdditionalPropertiesTest {
    private final JsonSchemaGenerator schemaGenerator = JsonSchemaGeneratorBuilder.draftV4Schema().build();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Test
    public void testGenerateSaleItemSchema() throws JsonProcessingException {
        ObjectNode schema = TestUtility.generateSchema(this.schemaGenerator, SaleItem.class);
        TestUtility.testProperties(schema, "idSale", "name");
        Assert.assertFalse((boolean)schema.get("additionalProperties").asBoolean());
    }

    @Test
    public void testGenerateSaleSchema() throws JsonProcessingException {
        ObjectNode schema = TestUtility.generateSchema(this.schemaGenerator, Sale.class);
        Assert.assertFalse((boolean)schema.get("additionalProperties").asBoolean());
        ObjectNode properties = TestUtility.testWithProperties(schema, "id", "saleItems");
        Assert.assertFalse((boolean)properties.findValue("additionalProperties").asBoolean());
    }

    @JsonSchema(title="Sale Item Child Schema", additionalProperties=false)
    static class SaleItem {
        int idSale;
        String name;

        SaleItem() {
        }

        @JsonProperty
        public int getIdSale() {
            return this.idSale;
        }

        public void setIdSale(int idSale) {
            this.idSale = idSale;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    @JsonSchema(title="Sale Parent Schema", additionalProperties=false)
    static class Sale {
        int id;
        List<SaleItem> saleItems;

        Sale() {
        }

        @JsonProperty
        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        @JsonProperty
        public List<SaleItem> getSaleItems() {
            return this.saleItems;
        }

        public void setSaleItems(List<SaleItem> saleItems) {
            this.saleItems = saleItems;
        }
    }
}

