/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.bool;

import de.softwareforge.bool.antlr4.BooleanGrammarBaseVisitor;
import de.softwareforge.bool.antlr4.BooleanGrammarParser;
import java.util.function.Function;
import org.antlr.v4.runtime.tree.ParseTree;

class EvaluationVisitor
extends BooleanGrammarBaseVisitor<Boolean> {
    private final Function<String, Boolean> identifierProvider;

    EvaluationVisitor(Function<String, Boolean> identifierProvider) {
        this.identifierProvider = identifierProvider;
    }

    @Override
    public Boolean visitIdentifier(BooleanGrammarParser.IdentifierContext ctx) {
        String name = ctx.IDENTIFIER().getText();
        Boolean result = this.identifierProvider.apply(name);
        if (result == null) {
            throw new IllegalStateException("Identifier '" + name + "' is null");
        }
        return result;
    }

    @Override
    public Boolean visitBinaryOp(BooleanGrammarParser.BinaryOpContext ctx) {
        if (ctx.AND() != null) {
            return (Boolean)this.visit((ParseTree)ctx.left) != false && (Boolean)this.visit((ParseTree)ctx.right) != false;
        }
        if (ctx.OR() != null) {
            return (Boolean)this.visit((ParseTree)ctx.left) != false || (Boolean)this.visit((ParseTree)ctx.right) != false;
        }
        throw new IllegalStateException("Unsupported binary operator: " + ctx.operator.getText());
    }

    @Override
    public Boolean visitNegationExpr(BooleanGrammarParser.NegationExprContext ctx) {
        return (Boolean)this.visit((ParseTree)ctx.expression()) == false;
    }

    @Override
    public Boolean visitParensExpr(BooleanGrammarParser.ParensExprContext ctx) {
        return (Boolean)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public Boolean visitLiteral(BooleanGrammarParser.LiteralContext ctx) {
        if (ctx.TRUE() != null) {
            return Boolean.TRUE;
        }
        if (ctx.FALSE() != null) {
            return Boolean.FALSE;
        }
        throw new IllegalStateException("Unsupported literal: " + ctx.getText());
    }

    protected Boolean defaultResult() {
        return Boolean.TRUE;
    }

    protected Boolean aggregateResult(Boolean aggregate, Boolean nextResult) {
        return aggregate != false && nextResult != false;
    }
}

