/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.socketio.emitter;

import de.smartsquare.socketio.emitter.Message;
import de.smartsquare.socketio.emitter.Metadata;
import de.smartsquare.socketio.emitter.packers.MapPacker;
import de.smartsquare.socketio.emitter.packers.TextPacker;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@kotlin.Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/smartsquare/socketio/emitter/Emitter;", "", "jedis", "Lredis/clients/jedis/JedisPool;", "id", "", "namespace", "(Lredis/clients/jedis/JedisPool;Ljava/lang/String;Ljava/lang/String;)V", "jsonPacker", "Lde/smartsquare/socketio/emitter/packers/MapPacker;", "textPacker", "Lde/smartsquare/socketio/emitter/packers/TextPacker;", "broadcast", "", "message", "Lde/smartsquare/socketio/emitter/Message;", "rooms", "", "except", "socket-io-redis-emitter"})
public final class Emitter {
    @NotNull
    private final JedisPool jedis;
    @NotNull
    private final String id;
    @NotNull
    private final String namespace;
    @NotNull
    private final TextPacker textPacker;
    @NotNull
    private final MapPacker jsonPacker;

    @JvmOverloads
    public Emitter(@NotNull JedisPool jedis, @NotNull String id, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)jedis, (String)"jedis");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        this.jedis = jedis;
        this.id = id;
        this.namespace = namespace;
        this.textPacker = new TextPacker();
        this.jsonPacker = new MapPacker();
    }

    public /* synthetic */ Emitter(JedisPool jedisPool, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "emitter";
        }
        if ((n & 4) != 0) {
            string2 = "/";
        }
        this(jedisPool, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final void broadcast(@NotNull Message message, @NotNull List<String> rooms, @NotNull List<String> except) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(rooms, (String)"rooms");
        Intrinsics.checkNotNullParameter(except, (String)"except");
        Metadata metadata = new Metadata(this.id, this.namespace, rooms, except);
        Object object = message;
        if (object instanceof Message.MapMessage) {
            byArray = this.jsonPacker.pack((Message.MapMessage)message, metadata);
        } else if (object instanceof Message.TextMessage) {
            byArray = this.textPacker.pack((Message.TextMessage)message, metadata);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        byte[] payload = byArray;
        if (rooms.size() == 1) {
            object = (Closeable)this.jedis.getResource();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Object it = (Jedis)object;
                boolean bl3 = false;
                String string = "socket.io#" + this.namespace + '#' + (String)CollectionsKt.first(rooms) + '#';
                Charset charset = Charsets.UTF_8;
                boolean bl4 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray2 = string2.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
                it = it.publish(byArray2, payload);
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        object = (Closeable)this.jedis.getResource();
        boolean bl = false;
        boolean bl5 = false;
        Throwable throwable = null;
        try {
            Jedis it = (Jedis)object;
            boolean bl6 = false;
            String string = "socket.io#" + this.namespace + '#';
            Charset charset = Charsets.UTF_8;
            boolean bl7 = false;
            String string3 = string;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray3 = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
            Long l = it.publish(byArray3, payload);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void broadcast$default(Emitter emitter, Message message, List list, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        emitter.broadcast(message, list, list2);
    }

    @JvmOverloads
    public Emitter(@NotNull JedisPool jedis, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)jedis, (String)"jedis");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this(jedis, id, null, 4, null);
    }

    @JvmOverloads
    public Emitter(@NotNull JedisPool jedis) {
        Intrinsics.checkNotNullParameter((Object)jedis, (String)"jedis");
        this(jedis, null, null, 6, null);
    }

    @JvmOverloads
    public final void broadcast(@NotNull Message message, @NotNull List<String> rooms) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(rooms, (String)"rooms");
        Emitter.broadcast$default(this, message, rooms, null, 4, null);
    }

    @JvmOverloads
    public final void broadcast(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Emitter.broadcast$default(this, message, null, null, 6, null);
    }
}

