/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.socketio.emitter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.smartsquare.socketio.emitter.MessageConverter;
import de.smartsquare.socketio.emitter.RedisPublisher;
import de.smartsquare.socketio.emitter.SocketIoMessage;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.msgpack.jackson.dataformat.MessagePackFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ8\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00012\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/smartsquare/socketio/emitter/Emitter;", "", "redisPublisher", "Lde/smartsquare/socketio/emitter/RedisPublisher;", "id", "", "namespace", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lde/smartsquare/socketio/emitter/RedisPublisher;Ljava/lang/String;Ljava/lang/String;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "messageConverter", "Lde/smartsquare/socketio/emitter/MessageConverter;", "broadcast", "", "topic", "value", "rooms", "", "except", "socket-io-redis-emitter"})
public final class Emitter {
    @NotNull
    private final RedisPublisher redisPublisher;
    @NotNull
    private final String id;
    @NotNull
    private final String namespace;
    @NotNull
    private final MessageConverter messageConverter;

    @JvmOverloads
    public Emitter(@NotNull RedisPublisher redisPublisher, @NotNull String id, @NotNull String namespace, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)redisPublisher, (String)"redisPublisher");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.redisPublisher = redisPublisher;
        this.id = id;
        this.namespace = namespace;
        this.messageConverter = new MessageConverter(objectMapper);
    }

    public /* synthetic */ Emitter(RedisPublisher redisPublisher, String string, String string2, ObjectMapper objectMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "emitter";
        }
        if ((n & 4) != 0) {
            string2 = "/";
        }
        if ((n & 8) != 0) {
            ObjectMapper objectMapper2 = new ObjectMapper((JsonFactory)new MessagePackFactory()).findAndRegisterModules().disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"disable(...)");
            objectMapper = objectMapper2;
        }
        this(redisPublisher, string, string2, objectMapper);
    }

    @JvmOverloads
    public final void broadcast(@NotNull String topic, @NotNull Object value, @NotNull List<String> rooms, @NotNull List<String> except) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(rooms, (String)"rooms");
        Intrinsics.checkNotNullParameter(except, (String)"except");
        byte[] payload = this.messageConverter.convert(new SocketIoMessage(this.id, topic, value, this.namespace, rooms, except));
        if (rooms.size() == 1) {
            this.redisPublisher.publish("socket.io#" + this.namespace + '#' + (String)CollectionsKt.first(rooms) + '#', payload);
        } else {
            this.redisPublisher.publish("socket.io#" + this.namespace + '#', payload);
        }
    }

    public static /* synthetic */ void broadcast$default(Emitter emitter, String string, Object object, List list, List list2, int n, Object object2) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        emitter.broadcast(string, object, list, list2);
    }

    @JvmOverloads
    public Emitter(@NotNull RedisPublisher redisPublisher, @NotNull String id, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)redisPublisher, (String)"redisPublisher");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        this(redisPublisher, id, namespace, null, 8, null);
    }

    @JvmOverloads
    public Emitter(@NotNull RedisPublisher redisPublisher, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)redisPublisher, (String)"redisPublisher");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this(redisPublisher, id, null, null, 12, null);
    }

    @JvmOverloads
    public Emitter(@NotNull RedisPublisher redisPublisher) {
        Intrinsics.checkNotNullParameter((Object)redisPublisher, (String)"redisPublisher");
        this(redisPublisher, null, null, null, 14, null);
    }

    @JvmOverloads
    public final void broadcast(@NotNull String topic, @NotNull Object value, @NotNull List<String> rooms) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(rooms, (String)"rooms");
        Emitter.broadcast$default(this, topic, value, rooms, null, 8, null);
    }

    @JvmOverloads
    public final void broadcast(@NotNull String topic, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Emitter.broadcast$default(this, topic, value, null, null, 12, null);
    }
}

