/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.socketio.emitter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.smartsquare.socketio.emitter.MessageConverter;
import de.smartsquare.socketio.emitter.SocketIoMessage;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ8\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00012\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/smartsquare/socketio/emitter/Emitter;", "", "jedis", "Lredis/clients/jedis/JedisPool;", "id", "", "namespace", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lredis/clients/jedis/JedisPool;Ljava/lang/String;Ljava/lang/String;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "messageConverter", "Lde/smartsquare/socketio/emitter/MessageConverter;", "broadcast", "", "topic", "value", "rooms", "", "except", "socket-io-redis-emitter"})
public final class Emitter {
    @NotNull
    private final JedisPool jedis;
    @NotNull
    private final String id;
    @NotNull
    private final String namespace;
    @NotNull
    private final MessageConverter messageConverter;

    @JvmOverloads
    public Emitter(@NotNull JedisPool jedis, @NotNull String id, @NotNull String namespace, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)jedis, (String)"jedis");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.jedis = jedis;
        this.id = id;
        this.namespace = namespace;
        this.messageConverter = new MessageConverter(objectMapper);
    }

    public /* synthetic */ Emitter(JedisPool jedisPool, String string, String string2, ObjectMapper objectMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "emitter";
        }
        if ((n & 4) != 0) {
            string2 = "/";
        }
        if ((n & 8) != 0) {
            ObjectMapper objectMapper2 = new ObjectMapper((JsonFactory)new MessagePackFactory()).findAndRegisterModules().disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"ObjectMapper(MessagePackFactory())\n        .findAndRegisterModules()\n        .disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)");
            objectMapper = objectMapper2;
        }
        this(jedisPool, string, string2, objectMapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final void broadcast(@NotNull String topic, @NotNull Object value, @NotNull List<String> rooms, @NotNull List<String> except) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(rooms, (String)"rooms");
        Intrinsics.checkNotNullParameter(except, (String)"except");
        byte[] payload = this.messageConverter.convert(new SocketIoMessage(this.id, topic, value, this.namespace, rooms, except));
        if (rooms.size() == 1) {
            Closeable closeable = (Closeable)this.jedis.getResource();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Object it = (Jedis)closeable;
                boolean bl3 = false;
                String string = "socket.io#" + this.namespace + '#' + (String)CollectionsKt.first(rooms) + '#';
                Charset charset = Charsets.UTF_8;
                boolean bl4 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string2.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                it = it.publish(byArray, payload);
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        Closeable closeable = (Closeable)this.jedis.getResource();
        boolean bl = false;
        boolean bl5 = false;
        Throwable throwable = null;
        try {
            Jedis it = (Jedis)closeable;
            boolean bl6 = false;
            String string = "socket.io#" + this.namespace + '#';
            Charset charset = Charsets.UTF_8;
            boolean bl7 = false;
            String string3 = string;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            Long l = it.publish(byArray, payload);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void broadcast$default(Emitter emitter, String string, Object object, List list, List list2, int n, Object object2) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        emitter.broadcast(string, object, list, list2);
    }

    @JvmOverloads
    public Emitter(@NotNull JedisPool jedis, @NotNull String id, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)jedis, (String)"jedis");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        this(jedis, id, namespace, null, 8, null);
    }

    @JvmOverloads
    public Emitter(@NotNull JedisPool jedis, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)jedis, (String)"jedis");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this(jedis, id, null, null, 12, null);
    }

    @JvmOverloads
    public Emitter(@NotNull JedisPool jedis) {
        Intrinsics.checkNotNullParameter((Object)jedis, (String)"jedis");
        this(jedis, null, null, null, 14, null);
    }

    @JvmOverloads
    public final void broadcast(@NotNull String topic, @NotNull Object value, @NotNull List<String> rooms) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(rooms, (String)"rooms");
        Emitter.broadcast$default(this, topic, value, rooms, null, 8, null);
    }

    @JvmOverloads
    public final void broadcast(@NotNull String topic, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Emitter.broadcast$default(this, topic, value, null, null, 12, null);
    }
}

