/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.starter.mqtt;

import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.mqtt3.Mqtt3AsyncClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3Client;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3PublishBuilder;
import de.smartsquare.starter.mqtt.MqttMessageAdapter;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/smartsquare/starter/mqtt/MqttPublisher;", "", "adapter", "Lde/smartsquare/starter/mqtt/MqttMessageAdapter;", "client", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3Client;", "(Lde/smartsquare/starter/mqtt/MqttMessageAdapter;Lcom/hivemq/client/mqtt/mqtt3/Mqtt3Client;)V", "asyncClient", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3AsyncClient;", "Lorg/jetbrains/annotations/NotNull;", "publish", "Ljava/util/concurrent/CompletableFuture;", "Lcom/hivemq/client/mqtt/mqtt3/message/publish/Mqtt3Publish;", "topic", "", "qos", "Lcom/hivemq/client/mqtt/datatypes/MqttQos;", "payload", "mqtt-starter"})
public class MqttPublisher {
    private final Mqtt3AsyncClient asyncClient;
    private final MqttMessageAdapter adapter;

    @NotNull
    public CompletableFuture<Mqtt3Publish> publish(@NotNull String topic, @NotNull MqttQos qos, @NotNull Object payload) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)qos, (String)"qos");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        CompletableFuture completableFuture = this.asyncClient.publish(((Mqtt3PublishBuilder.Complete)((Mqtt3PublishBuilder.Complete)((Mqtt3PublishBuilder.Complete)Mqtt3Publish.builder().topic(topic)).qos(qos)).payload(this.adapter.adapt(payload))).build());
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"asyncClient.publish(\n   \u2026       .build()\n        )");
        return completableFuture;
    }

    public MqttPublisher(@NotNull MqttMessageAdapter adapter, @NotNull Mqtt3Client client) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.adapter = adapter;
        Mqtt3AsyncClient mqtt3AsyncClient = client.toAsync();
        Intrinsics.checkNotNullExpressionValue((Object)mqtt3AsyncClient, (String)"client.toAsync()");
        this.asyncClient = mqtt3AsyncClient;
    }
}

