/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.starter.mqtt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hivemq.client.mqtt.datatypes.MqttTopic;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tJ\u000e\u0010\u0005\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/smartsquare/starter/mqtt/MqttMessageAdapter;", "", "jackson", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "adapt", "message", "Lcom/hivemq/client/mqtt/mqtt3/message/publish/Mqtt3Publish;", "targetType", "Ljava/lang/Class;", "", "payload", "mqtt-starter"})
public final class MqttMessageAdapter {
    private final ObjectMapper jackson;

    @NotNull
    public final Object adapt(@NotNull Mqtt3Publish message, @NotNull Class<?> targetType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(targetType, (String)"targetType");
        if (targetType.isAssignableFrom(MqttTopic.class)) {
            object = message.getTopic();
        } else if (targetType.isAssignableFrom(String.class)) {
            byte[] byArray = message.getPayloadAsBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"message.payloadAsBytes");
            object = StringsKt.decodeToString((byte[])byArray);
        } else {
            object = this.jackson.readValue(message.getPayloadAsBytes(), targetType);
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"when {\n            targe\u2026es, targetType)\n        }");
        return object;
    }

    @NotNull
    public final byte[] adapt(@NotNull Object payload) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Object object = payload;
        if (object instanceof String) {
            byArray = StringsKt.encodeToByteArray((String)((String)payload));
        } else {
            String string = this.jackson.writeValueAsString(payload);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jackson.writeValueAsString(payload)");
            byArray = StringsKt.encodeToByteArray((String)string);
        }
        return byArray;
    }

    public MqttMessageAdapter(@NotNull ObjectMapper jackson) {
        Intrinsics.checkNotNullParameter((Object)jackson, (String)"jackson");
        this.jackson = jackson;
    }
}

