/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.starter.mqtt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.hivemq.client.mqtt.MqttClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3Client;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientBuilder;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt3.message.connect.connack.Mqtt3ConnAck;
import com.hivemq.client.mqtt.mqtt3.message.connect.connack.Mqtt3ConnAckReturnCode;
import de.smartsquare.starter.mqtt.Adapter;
import de.smartsquare.starter.mqtt.AnnotationCollector;
import de.smartsquare.starter.mqtt.BrokerConnectException;
import de.smartsquare.starter.mqtt.MqttProperties;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MqttClient.class})
@EnableConfigurationProperties(value={MqttProperties.class})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\b\u0010\u0010\u001a\u00020\tH\u0017J\b\u0010\u0011\u001a\u00020\u000bH\u0017J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0017R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/smartsquare/starter/mqtt/MqttAutoConfiguration;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "adapter", "Lde/smartsquare/starter/mqtt/Adapter;", "collector", "Lde/smartsquare/starter/mqtt/AnnotationCollector;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "config", "Lde/smartsquare/starter/mqtt/MqttProperties;", "client", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3Client;", "annotationCollector", "jackson", "mqttClient", "mqtt-starter"})
public class MqttAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean
    @NotNull
    public Mqtt3Client mqttClient(@NotNull MqttProperties config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Mqtt3SimpleAuthBuilder.Nested.Complete complete = (Mqtt3SimpleAuthBuilder.Nested.Complete)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)Mqtt3Client.builder().identifier(config.getClientId())).serverHost(config.getHost())).serverPort(config.getPort())).automaticReconnectWithDefaultConfig()).simpleAuth().username(config.getUsername());
        String string = config.getPassword();
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        Mqtt3ClientBuilder baseClient = (Mqtt3ClientBuilder)((Mqtt3SimpleAuthBuilder.Nested.Complete)complete.password(byArray)).applySimpleAuth();
        Mqtt3Client mqtt3Client = config.getSsl() ? ((Mqtt3ClientBuilder)baseClient.sslWithDefaultConfig()).build() : baseClient.build();
        Intrinsics.checkNotNullExpressionValue((Object)mqtt3Client, (String)"if (config.ssl) {\n      \u2026eClient.build()\n        }");
        Mqtt3Client client = mqtt3Client;
        this.logger.debug("Connecting to " + config.getUsername() + '@' + config.getHost() + ':' + config.getPort() + "...");
        try {
            Mqtt3ConnAck acknowledgement;
            Mqtt3ConnAck mqtt3ConnAck = acknowledgement = (Mqtt3ConnAck)client.toAsync().connect().get(10L, TimeUnit.SECONDS);
            Intrinsics.checkNotNullExpressionValue((Object)mqtt3ConnAck, (String)"acknowledgement");
            Mqtt3ConnAckReturnCode mqtt3ConnAckReturnCode = mqtt3ConnAck.getReturnCode();
            Intrinsics.checkNotNullExpressionValue((Object)mqtt3ConnAckReturnCode, (String)"acknowledgement.returnCode");
            if (mqtt3ConnAckReturnCode.isError()) {
                throw (Throwable)new BrokerConnectException(acknowledgement);
            }
            this.logger.debug("Successfully connected to broker.");
            return client;
        }
        catch (TimeoutException e) {
            throw (Throwable)new BrokerConnectException("Broker " + config.getHost() + ':' + config.getPort() + " did not respond within 10 seconds.");
        }
    }

    @Bean
    @NotNull
    public AnnotationCollector annotationCollector() {
        return new AnnotationCollector();
    }

    @Bean
    @NotNull
    public ObjectMapper jackson() {
        ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper().findAndRegisterModules();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"jacksonObjectMapper().findAndRegisterModules()");
        return objectMapper;
    }

    @Bean
    @NotNull
    public Adapter adapter(@NotNull AnnotationCollector collector, @NotNull ObjectMapper mapper, @NotNull MqttProperties config, @NotNull Mqtt3Client client) {
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return new Adapter(collector, config, mapper, client);
    }
}

