/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.starter.mqtt;

import com.hivemq.client.mqtt.datatypes.MqttTopic;
import de.smartsquare.starter.mqtt.MqttConfigurationException;
import de.smartsquare.starter.mqtt.MqttSubscribe;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\f\u0010\u0011\u001a\u00020\u0012*\u00020\nH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lde/smartsquare/starter/mqtt/AnnotationCollector;", "Lorg/springframework/beans/factory/config/BeanPostProcessor;", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "subscribers", "", "", "", "Ljava/lang/reflect/Method;", "getSubscribers", "()Ljava/util/Map;", "postProcessBeforeInitialization", "bean", "beanName", "", "isInvalidSignature", "", "mqtt-starter"})
public final class AnnotationCollector
implements BeanPostProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private final Map<Object, List<Method>> subscribers;

    @NotNull
    public final Map<Object, List<Method>> getSubscribers() {
        return this.subscribers;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Object postProcessBeforeInitialization(@NotNull Object bean, @NotNull String beanName) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
        Method[] methodArray = bean.getClass().getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"bean.javaClass.methods");
        Method[] $this$filter$iv = methodArray;
        boolean $i$f$filter = false;
        Method[] methodArray2 = $this$filter$iv;
        Iterable<void> destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var9_12 = $this$filterTo$iv$iv2;
        int n = ((void)var9_12).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var9_12[i];
            boolean bl = false;
            if (!it.isAnnotationPresent(MqttSubscribe.class)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List collectedSubscribers = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = collectedSubscribers;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Method it = (Method)element$iv$iv;
            boolean bl = false;
            Method method = it;
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"it");
            if (!this.isInvalidSignature(method)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List erroneousSubscriberDefinitions = (List)destination$iv$iv2;
        $this$filter$iv2 = erroneousSubscriberDefinitions;
        boolean bl = false;
        if (!$this$filter$iv2.isEmpty()) {
            String joinedSubscribers2 = CollectionsKt.joinToString$default((Iterable)erroneousSubscriberDefinitions, (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<Method, CharSequence>(beanName){
                final /* synthetic */ String $beanName;

                @NotNull
                public final CharSequence invoke(Method it) {
                    StringBuilder stringBuilder = new StringBuilder().append(this.$beanName).append('#');
                    Method method = it;
                    Intrinsics.checkNotNullExpressionValue((Object)method, (String)"it");
                    return stringBuilder.append(method.getName()).toString();
                }
                {
                    this.$beanName = string;
                    super(1);
                }
            }), (int)30, null);
            throw (Throwable)new MqttConfigurationException(StringsKt.trimMargin$default((String)("Following subscribers are invalid [" + joinedSubscribers2 + "].\n                   Functions annotated with 'MqttSubscriber' can only have the following parameters:\n                     - the MqttTopic\n                     - any type of deserialized JSON payload\n                     - or both\n                "), null, (int)1, null));
        }
        for (Method subscriber : collectedSubscribers) {
            StringBuilder stringBuilder = new StringBuilder().append("Found subscriber ");
            Method method = subscriber;
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"subscriber");
            this.logger.debug(stringBuilder.append(method.getName()).append(" of ").append(bean.getClass().getSimpleName()).append('.').toString());
            this.subscribers.put(bean, CollectionsKt.plus((Collection)this.subscribers.getOrDefault(bean, CollectionsKt.emptyList()), (Iterable)CollectionsKt.listOf((Object)subscriber)));
        }
        return bean;
    }

    private final boolean isInvalidSignature(Method $this$isInvalidSignature) {
        int n;
        Class<?>[] classArray = $this$isInvalidSignature.getParameterTypes();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"this.parameterTypes");
        Class<?>[] $this$count$iv = classArray;
        boolean $i$f$count = false;
        int count$iv = 0;
        Class<?>[] classArray2 = $this$count$iv;
        int n2 = classArray2.length;
        for (n = 0; n < n2; ++n) {
            Class<MqttTopic> element$iv;
            Class<MqttTopic> it = element$iv = classArray2[n];
            boolean bl = false;
            if (!it.isAssignableFrom(MqttTopic.class)) continue;
            ++count$iv;
        }
        int topicParamCount = count$iv;
        Class<?>[] classArray3 = $this$isInvalidSignature.getParameterTypes();
        Intrinsics.checkNotNullExpressionValue(classArray3, (String)"this.parameterTypes");
        Class<?>[] $this$count$iv2 = classArray3;
        boolean $i$f$count2 = false;
        int count$iv2 = 0;
        Class<?>[] classArray4 = $this$count$iv2;
        n = classArray4.length;
        for (int i = 0; i < n; ++i) {
            Class<MqttTopic> element$iv;
            Class<MqttTopic> it = element$iv = classArray4[i];
            boolean bl = false;
            if (!(!it.isAssignableFrom(MqttTopic.class))) continue;
            ++count$iv2;
        }
        int payloadParamCount = count$iv2;
        return topicParamCount > 1 || payloadParamCount > 1;
    }

    public AnnotationCollector() {
        boolean bl = false;
        this.subscribers = new LinkedHashMap();
    }
}

