/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.starter.mqtt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hivemq.client.mqtt.datatypes.MqttTopic;
import com.hivemq.client.mqtt.mqtt3.Mqtt3AsyncClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3Client;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import de.smartsquare.starter.mqtt.AnnotationCollector;
import de.smartsquare.starter.mqtt.MqttProperties;
import de.smartsquare.starter.mqtt.MqttSubscribe;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J,\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002J*\u0010\u001c\u001a\u0004\u0018\u00010\u00172\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/smartsquare/starter/mqtt/Adapter;", "Lorg/springframework/beans/factory/InitializingBean;", "collector", "Lde/smartsquare/starter/mqtt/AnnotationCollector;", "config", "Lde/smartsquare/starter/mqtt/MqttProperties;", "jackson", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "client", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3Client;", "(Lde/smartsquare/starter/mqtt/AnnotationCollector;Lde/smartsquare/starter/mqtt/MqttProperties;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/hivemq/client/mqtt/mqtt3/Mqtt3Client;)V", "asyncClient", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3AsyncClient;", "Lorg/jetbrains/annotations/NotNull;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "afterPropertiesSet", "", "deliver", "subscriber", "Ljava/lang/reflect/Method;", "bean", "", "msg", "Lcom/hivemq/client/mqtt/mqtt3/message/publish/Mqtt3Publish;", "payloadType", "Ljava/lang/Class;", "resolve", "it", "mqtt-starter"})
public final class Adapter
implements InitializingBean {
    private final Logger logger;
    private final Mqtt3AsyncClient asyncClient;
    private final AnnotationCollector collector;
    private final MqttProperties config;
    private final ObjectMapper jackson;
    private final Mqtt3Client client;

    /*
     * WARNING - void declaration
     */
    public void afterPropertiesSet() {
        Object object = this.collector.getSubscribers();
        boolean bl = false;
        Iterator<Map.Entry<Object, List<Method>>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, List<Method>> entry;
            Map.Entry<Object, List<Method>> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            List<Method> subscribers = entry2.getValue();
            for (Method subscriber : subscribers) {
                void bean;
                Object[] objectArray = subscriber.getParameterTypes();
                Intrinsics.checkNotNullExpressionValue(objectArray, (String)"subscriber.parameterTypes");
                Class payloadType = (Class)ArraysKt.first((Object[])objectArray);
                MqttSubscribe annotation = subscriber.getAnnotation(MqttSubscribe.class);
                String topic = annotation.shared() && this.config.getGroup() != null ? "$share/" + this.config.getGroup() + '/' + annotation.topic() : annotation.topic();
                ((Mqtt3AsyncClient.Mqtt3SubscribeAndCallbackBuilder.Start.Complete)((Mqtt3AsyncClient.Mqtt3SubscribeAndCallbackBuilder.Start.Complete)this.asyncClient.subscribeWith().topicFilter(topic)).qos(annotation.qos())).callback((Consumer)new Consumer<Mqtt3Publish>(this, subscriber, bean, payloadType){
                    final /* synthetic */ Adapter this$0;
                    final /* synthetic */ Method $subscriber;
                    final /* synthetic */ Object $bean;
                    final /* synthetic */ Class $payloadType;

                    public final void accept(Mqtt3Publish msg) {
                        Mqtt3Publish mqtt3Publish = msg;
                        Intrinsics.checkNotNullExpressionValue((Object)mqtt3Publish, (String)"msg");
                        Class clazz = this.$payloadType;
                        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"payloadType");
                        Adapter.access$deliver(this.this$0, this.$subscriber, this.$bean, mqtt3Publish, clazz);
                    }
                    {
                        this.this$0 = adapter;
                        this.$subscriber = method;
                        this.$bean = object;
                        this.$payloadType = clazz;
                    }
                }).send();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void deliver(Method subscriber, Object bean, Mqtt3Publish msg, Class<?> payloadType) {
        try {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Class<?>[] classArray = subscriber.getParameterTypes();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"subscriber.parameterTypes");
            Object $this$map$iv = classArray;
            boolean $i$f$map = false;
            Class<?>[] classArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((Class<?>[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            void var11_10 = $this$mapTo$iv$iv;
            int n = ((void)var11_10).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var15_14 = item$iv$iv = var11_10[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                Object object = this.resolve((Class<?>)v1, msg, payloadType);
                collection.add(object);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] parameters = objectArray;
            subscriber.invoke(bean, Arrays.copyOf(parameters, parameters.length));
        }
        catch (InvocationTargetException e) {
            this.logger.error("Error while delivering the message.", (Throwable)e);
        }
    }

    private final Object resolve(Class<?> it, Mqtt3Publish msg, Class<?> payloadType) {
        return it.isAssignableFrom(MqttTopic.class) ? msg.getTopic() : this.jackson.readValue(msg.getPayloadAsBytes(), payloadType);
    }

    public Adapter(@NotNull AnnotationCollector collector, @NotNull MqttProperties config, @NotNull ObjectMapper jackson, @NotNull Mqtt3Client client) {
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)jackson, (String)"jackson");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.collector = collector;
        this.config = config;
        this.jackson = jackson;
        this.client = client;
        this.logger = LoggerFactory.getLogger(this.getClass());
        Mqtt3AsyncClient mqtt3AsyncClient = this.client.toAsync();
        Intrinsics.checkNotNullExpressionValue((Object)mqtt3AsyncClient, (String)"client.toAsync()");
        this.asyncClient = mqtt3AsyncClient;
    }

    public static final /* synthetic */ void access$deliver(Adapter $this, Method subscriber, Object bean, Mqtt3Publish msg, Class payloadType) {
        $this.deliver(subscriber, bean, msg, payloadType);
    }
}

