/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.starter.mqtt;

import com.hivemq.client.annotations.CheckReturnValue;
import com.hivemq.client.mqtt.datatypes.MqttUtf8String;
import com.hivemq.client.mqtt.mqtt5.Mqtt5AsyncClient;
import com.hivemq.client.mqtt.mqtt5.Mqtt5BlockingClient;
import com.hivemq.client.mqtt.mqtt5.Mqtt5Client;
import com.hivemq.client.mqtt.mqtt5.Mqtt5ClientConfig;
import com.hivemq.client.mqtt.mqtt5.Mqtt5RxClient;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5SimpleAuth;
import com.hivemq.client.mqtt.mqtt5.message.connect.Mqtt5Connect;
import com.hivemq.client.mqtt.mqtt5.message.connect.connack.Mqtt5ConnAck;
import de.smartsquare.starter.mqtt.BrokerConnectException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u000e\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0097\u0001J\u000e\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0010H\u0097\u0001J\u000e\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0010H\u0097\u0001J\u000e\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0010H\u0097\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/smartsquare/starter/mqtt/SpringAwareMqtt5Client;", "Lcom/hivemq/client/mqtt/mqtt5/Mqtt5Client;", "Lorg/springframework/beans/factory/InitializingBean;", "Lorg/springframework/beans/factory/DisposableBean;", "delegate", "connectOptions", "Lcom/hivemq/client/mqtt/mqtt5/message/connect/Mqtt5Connect;", "(Lcom/hivemq/client/mqtt/mqtt5/Mqtt5Client;Lcom/hivemq/client/mqtt/mqtt5/message/connect/Mqtt5Connect;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "afterPropertiesSet", "", "destroy", "getConfig", "Lcom/hivemq/client/mqtt/mqtt5/Mqtt5ClientConfig;", "Lorg/jetbrains/annotations/NotNull;", "toAsync", "Lcom/hivemq/client/mqtt/mqtt5/Mqtt5AsyncClient;", "toBlocking", "Lcom/hivemq/client/mqtt/mqtt5/Mqtt5BlockingClient;", "toRx", "Lcom/hivemq/client/mqtt/mqtt5/Mqtt5RxClient;", "mqtt-starter"})
public final class SpringAwareMqtt5Client
implements Mqtt5Client,
InitializingBean,
DisposableBean {
    @NotNull
    private final Mqtt5Client delegate;
    @NotNull
    private final Mqtt5Connect connectOptions;
    private final Logger logger;

    public SpringAwareMqtt5Client(@NotNull Mqtt5Client delegate, @NotNull Mqtt5Connect connectOptions) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)connectOptions, (String)"connectOptions");
        this.delegate = delegate;
        this.connectOptions = connectOptions;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public /* synthetic */ SpringAwareMqtt5Client(Mqtt5Client mqtt5Client, Mqtt5Connect mqtt5Connect, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Mqtt5Connect mqtt5Connect2 = Mqtt5Connect.builder().build();
            Intrinsics.checkNotNullExpressionValue((Object)mqtt5Connect2, (String)"builder().build()");
            mqtt5Connect = mqtt5Connect2;
        }
        this(mqtt5Client, mqtt5Connect);
    }

    @CheckReturnValue
    @NotNull
    public Mqtt5AsyncClient toAsync() {
        return this.delegate.toAsync();
    }

    @CheckReturnValue
    @NotNull
    public Mqtt5BlockingClient toBlocking() {
        return this.delegate.toBlocking();
    }

    @CheckReturnValue
    @NotNull
    public Mqtt5RxClient toRx() {
        return this.delegate.toRx();
    }

    @NotNull
    public Mqtt5ClientConfig getConfig() {
        return this.delegate.getConfig();
    }

    public void afterPropertiesSet() {
        String string = this.delegate.getConfig().getServerHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"delegate.config.serverHost");
        String host = string;
        int port = this.delegate.getConfig().getServerPort();
        MqttUtf8String mqttUtf8String = this.delegate.getConfig().getSimpleAuth().flatMap(SpringAwareMqtt5Client::afterPropertiesSet$lambda-0).orElseGet(SpringAwareMqtt5Client::afterPropertiesSet$lambda-1);
        String username = mqttUtf8String == null ? null : mqttUtf8String.toString();
        this.logger.info("Connecting to " + (username != null ? Intrinsics.stringPlus((String)username, (Object)"@") : "") + host + ':' + port + " using mqtt 5...");
        try {
            Mqtt5ConnAck acknowledgement = (Mqtt5ConnAck)this.delegate.toAsync().connect(this.connectOptions).get(10L, TimeUnit.SECONDS);
            if (acknowledgement.getReasonCode().isError()) {
                Intrinsics.checkNotNullExpressionValue((Object)acknowledgement, (String)"acknowledgement");
                throw new BrokerConnectException(acknowledgement, null, 2, null);
            }
        }
        catch (TimeoutException error) {
            throw new BrokerConnectException("Failed to connect: Broker " + host + ':' + port + " did not respond within 10 seconds.", (Throwable)error);
        }
    }

    public void destroy() {
        this.delegate.toAsync().disconnect().get(10L, TimeUnit.SECONDS);
    }

    private static final Optional afterPropertiesSet$lambda-0(Mqtt5SimpleAuth it) {
        return it.getUsername();
    }

    private static final MqttUtf8String afterPropertiesSet$lambda-1() {
        return null;
    }
}

