/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.starter.mqtt;

import com.hivemq.client.annotations.CheckReturnValue;
import com.hivemq.client.mqtt.datatypes.MqttUtf8String;
import com.hivemq.client.mqtt.mqtt3.Mqtt3AsyncClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3BlockingClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3Client;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientConfig;
import com.hivemq.client.mqtt.mqtt3.Mqtt3RxClient;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuth;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3Connect;
import com.hivemq.client.mqtt.mqtt3.message.connect.connack.Mqtt3ConnAck;
import de.smartsquare.starter.mqtt.BrokerConnectException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u000e\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0097\u0001J\u000e\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0010H\u0097\u0001J\u000e\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0010H\u0097\u0001J\u000e\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0010H\u0097\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/smartsquare/starter/mqtt/SpringAwareMqtt3Client;", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3Client;", "Lorg/springframework/beans/factory/InitializingBean;", "Lorg/springframework/beans/factory/DisposableBean;", "delegate", "connectOptions", "Lcom/hivemq/client/mqtt/mqtt3/message/connect/Mqtt3Connect;", "(Lcom/hivemq/client/mqtt/mqtt3/Mqtt3Client;Lcom/hivemq/client/mqtt/mqtt3/message/connect/Mqtt3Connect;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "afterPropertiesSet", "", "destroy", "getConfig", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3ClientConfig;", "Lorg/jetbrains/annotations/NotNull;", "toAsync", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3AsyncClient;", "toBlocking", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3BlockingClient;", "toRx", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3RxClient;", "mqtt-starter"})
public final class SpringAwareMqtt3Client
implements Mqtt3Client,
InitializingBean,
DisposableBean {
    @NotNull
    private final Mqtt3Client delegate;
    @NotNull
    private final Mqtt3Connect connectOptions;
    private final Logger logger;

    public SpringAwareMqtt3Client(@NotNull Mqtt3Client delegate, @NotNull Mqtt3Connect connectOptions) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)connectOptions, (String)"connectOptions");
        this.delegate = delegate;
        this.connectOptions = connectOptions;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public /* synthetic */ SpringAwareMqtt3Client(Mqtt3Client mqtt3Client, Mqtt3Connect mqtt3Connect, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Mqtt3Connect mqtt3Connect2 = Mqtt3Connect.builder().build();
            Intrinsics.checkNotNullExpressionValue((Object)mqtt3Connect2, (String)"builder().build()");
            mqtt3Connect = mqtt3Connect2;
        }
        this(mqtt3Client, mqtt3Connect);
    }

    @CheckReturnValue
    @NotNull
    public Mqtt3AsyncClient toAsync() {
        return this.delegate.toAsync();
    }

    @CheckReturnValue
    @NotNull
    public Mqtt3BlockingClient toBlocking() {
        return this.delegate.toBlocking();
    }

    @CheckReturnValue
    @NotNull
    public Mqtt3RxClient toRx() {
        return this.delegate.toRx();
    }

    @NotNull
    public Mqtt3ClientConfig getConfig() {
        return this.delegate.getConfig();
    }

    public void afterPropertiesSet() {
        MqttUtf8String mqttUtf8String;
        String string = this.delegate.getConfig().getServerHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"delegate.config.serverHost");
        String host = string;
        int port = this.delegate.getConfig().getServerPort();
        Mqtt3SimpleAuth mqtt3SimpleAuth = this.delegate.getConfig().getSimpleAuth().orElseGet(SpringAwareMqtt3Client::afterPropertiesSet$lambda-0);
        String username = mqtt3SimpleAuth == null ? null : ((mqttUtf8String = mqtt3SimpleAuth.getUsername()) == null ? null : mqttUtf8String.toString());
        this.logger.info("Connecting to " + (username != null ? Intrinsics.stringPlus((String)username, (Object)"@") : "") + host + ':' + port + " using mqtt 3...");
        try {
            Mqtt3ConnAck acknowledgement = (Mqtt3ConnAck)this.delegate.toAsync().connect(this.connectOptions).get(10L, TimeUnit.SECONDS);
            if (acknowledgement.getReturnCode().isError()) {
                Intrinsics.checkNotNullExpressionValue((Object)acknowledgement, (String)"acknowledgement");
                throw new BrokerConnectException(acknowledgement, null, 2, null);
            }
        }
        catch (TimeoutException error) {
            throw new BrokerConnectException("Failed to connect: Broker " + host + ':' + port + " did not respond within 10 seconds.", (Throwable)error);
        }
    }

    public void destroy() {
        this.delegate.toAsync().disconnect().get(10L, TimeUnit.SECONDS);
    }

    private static final Mqtt3SimpleAuth afterPropertiesSet$lambda-0() {
        return null;
    }
}

