/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.starter.mqtt;

import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.datatypes.MqttTopic;
import de.smartsquare.starter.mqtt.AnnotationCollector;
import de.smartsquare.starter.mqtt.MqttMessageAdapter;
import de.smartsquare.starter.mqtt.MqttProperties;
import de.smartsquare.starter.mqtt.MqttSubscribe;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J2\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\r0\u001bH$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/smartsquare/starter/mqtt/MqttRouter;", "Lorg/springframework/beans/factory/InitializingBean;", "collector", "Lde/smartsquare/starter/mqtt/AnnotationCollector;", "adapter", "Lde/smartsquare/starter/mqtt/MqttMessageAdapter;", "config", "Lde/smartsquare/starter/mqtt/MqttProperties;", "(Lde/smartsquare/starter/mqtt/AnnotationCollector;Lde/smartsquare/starter/mqtt/MqttMessageAdapter;Lde/smartsquare/starter/mqtt/MqttProperties;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "afterPropertiesSet", "", "deliver", "subscriber", "Ljava/lang/reflect/Method;", "bean", "", "topic", "Lcom/hivemq/client/mqtt/datatypes/MqttTopic;", "payload", "", "subscribe", "", "qos", "Lcom/hivemq/client/mqtt/datatypes/MqttQos;", "Lkotlin/Function2;", "mqtt-starter"})
public abstract class MqttRouter
implements InitializingBean {
    @NotNull
    private final AnnotationCollector collector;
    @NotNull
    private final MqttMessageAdapter adapter;
    @NotNull
    private final MqttProperties config;
    private final Logger logger;

    public MqttRouter(@NotNull AnnotationCollector collector, @NotNull MqttMessageAdapter adapter, @NotNull MqttProperties config) {
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.collector = collector;
        this.adapter = adapter;
        this.config = config;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public void afterPropertiesSet() {
        Iterator iterator = (Map)this.collector.getSubscribers();
        boolean bl = false;
        Iterator iterator2 = iterator.entrySet().iterator();
        while (iterator2.hasNext()) {
            Iterator iterator3 = iterator = iterator2.next();
            boolean bl2 = false;
            Object bean = iterator3.getKey();
            Iterator iterator4 = iterator;
            boolean bl3 = false;
            List subscribers = (List)iterator4.getValue();
            for (AnnotationCollector.ResolvedMqttSubscriber resolvedMqttSubscriber : subscribers) {
                Method subscriberMethod = resolvedMqttSubscriber.component1();
                MqttSubscribe subscriberAnnotation = resolvedMqttSubscriber.component2();
                String subscribeTopic = subscriberAnnotation.shared() && this.config.getGroup() != null ? "$share/" + this.config.getGroup() + '/' + subscriberAnnotation.topic() : subscriberAnnotation.topic();
                this.subscribe(subscribeTopic, subscriberAnnotation.qos(), (Function2<? super MqttTopic, ? super byte[], Unit>)((Function2)new Function2<MqttTopic, byte[], Unit>(this, subscriberMethod, bean){
                    final /* synthetic */ MqttRouter this$0;
                    final /* synthetic */ Method $subscriberMethod;
                    final /* synthetic */ Object $bean;
                    {
                        this.this$0 = $receiver;
                        this.$subscriberMethod = $subscriberMethod;
                        this.$bean = $bean;
                        super(2);
                    }

                    public final void invoke(@NotNull MqttTopic topic, @NotNull byte[] payload) {
                        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
                        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
                        Object object = this.$bean;
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bean");
                        MqttRouter.access$deliver(this.this$0, this.$subscriberMethod, object, topic, payload);
                    }
                }));
            }
        }
    }

    protected abstract void subscribe(@NotNull String var1, @NotNull MqttQos var2, @NotNull Function2<? super MqttTopic, ? super byte[], Unit> var3);

    /*
     * WARNING - void declaration
     */
    private final void deliver(Method subscriber, Object bean, MqttTopic topic, byte[] payload) {
        try {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Class<?>[] classArray = subscriber.getParameterTypes();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"subscriber.parameterTypes");
            Object $this$map$iv = classArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((Object[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Class clazz = (Class)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Object t = this.adapter.adapt(topic, payload, it);
                collection.add(t);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray2 = thisCollection$iv.toArray(new Object[0]);
            if (objectArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] parameters = objectArray2;
            subscriber.invoke(bean, Arrays.copyOf(parameters, parameters.length));
        }
        catch (InvocationTargetException e) {
            this.logger.error("Error while delivering mqtt message.", e.getCause());
        }
    }

    public static final /* synthetic */ void access$deliver(MqttRouter $this, Method subscriber, Object bean, MqttTopic topic, byte[] payload) {
        $this.deliver(subscriber, bean, topic, payload);
    }
}

