/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.starter.mqtt;

import de.smartsquare.starter.mqtt.MqttVersion;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;
import org.springframework.validation.annotation.Validated;

@Validated
@ConstructorBinding
@ConfigurationProperties(prefix="mqtt")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u001f\b\u0097\b\u0018\u00002\u00020\u0001Bg\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\nH\u00c6\u0003J\t\u0010!\u001a\u00020\nH\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003Jk\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\r\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010%\u001a\u00020\n2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020\u0005H\u00d6\u0001J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u000b\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0016\u0010\u0002\u001a\u00020\u00038\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0016\u0010\u0004\u001a\u00020\u00058\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0016\u0010\r\u001a\u00020\u00058\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017\u00a8\u0006)"}, d2={"Lde/smartsquare/starter/mqtt/MqttProperties;", "", "host", "", "port", "", "clientId", "username", "password", "ssl", "", "clean", "group", "version", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZLjava/lang/String;I)V", "getClean", "()Z", "getClientId", "()Ljava/lang/String;", "getGroup", "getHost", "getPassword", "getPort", "()I", "getSsl", "getUsername", "getVersion", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toString", "mqtt-starter"})
public class MqttProperties {
    @NotNull
    private final String host;
    @Min(value=0L)
    @Max(value=65535L)
    private final int port;
    @Nullable
    private final String clientId;
    @Nullable
    private final String username;
    @Nullable
    private final String password;
    private final boolean ssl;
    private final boolean clean;
    @Nullable
    private final String group;
    private final int version;

    public MqttProperties(@NotNull String host, int port, @Nullable String clientId, @Nullable String username, @Nullable String password, boolean ssl, boolean clean, @Nullable String group, int version) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
        this.port = port;
        this.clientId = clientId;
        this.username = username;
        this.password = password;
        this.ssl = ssl;
        this.clean = clean;
        this.group = group;
        this.version = version;
    }

    public /* synthetic */ MqttProperties(String string, int n, String string2, String string3, String string4, boolean bl, boolean bl2, String string5, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            string = "localhost";
        }
        if ((n3 & 2) != 0) {
            n = 1883;
        }
        if ((n3 & 4) != 0) {
            string2 = null;
        }
        if ((n3 & 8) != 0) {
            string3 = null;
        }
        if ((n3 & 0x10) != 0) {
            string4 = null;
        }
        if ((n3 & 0x20) != 0) {
            bl = false;
        }
        if ((n3 & 0x40) != 0) {
            bl2 = true;
        }
        if ((n3 & 0x80) != 0) {
            string5 = null;
        }
        if ((n3 & 0x100) != 0) {
            n2 = 3;
        }
        this(string, n, string2, string3, string4, bl, bl2, string5, n2);
    }

    @NotEmpty
    @NotNull
    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public boolean getSsl() {
        return this.ssl;
    }

    public boolean getClean() {
        return this.clean;
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    @MqttVersion
    public int getVersion() {
        return this.version;
    }

    @NotNull
    public final String component1() {
        return this.getHost();
    }

    public final int component2() {
        return this.getPort();
    }

    @Nullable
    public final String component3() {
        return this.getClientId();
    }

    @Nullable
    public final String component4() {
        return this.getUsername();
    }

    @Nullable
    public final String component5() {
        return this.getPassword();
    }

    public final boolean component6() {
        return this.getSsl();
    }

    public final boolean component7() {
        return this.getClean();
    }

    @Nullable
    public final String component8() {
        return this.getGroup();
    }

    public final int component9() {
        return this.getVersion();
    }

    @NotNull
    public final MqttProperties copy(@NotNull String host, int port, @Nullable String clientId, @Nullable String username, @Nullable String password, boolean ssl, boolean clean, @Nullable String group, int version) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return new MqttProperties(host, port, clientId, username, password, ssl, clean, group, version);
    }

    public static /* synthetic */ MqttProperties copy$default(MqttProperties mqttProperties, String string, int n, String string2, String string3, String string4, boolean bl, boolean bl2, String string5, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
        }
        if ((n3 & 1) != 0) {
            string = mqttProperties.getHost();
        }
        if ((n3 & 2) != 0) {
            n = mqttProperties.getPort();
        }
        if ((n3 & 4) != 0) {
            string2 = mqttProperties.getClientId();
        }
        if ((n3 & 8) != 0) {
            string3 = mqttProperties.getUsername();
        }
        if ((n3 & 0x10) != 0) {
            string4 = mqttProperties.getPassword();
        }
        if ((n3 & 0x20) != 0) {
            bl = mqttProperties.getSsl();
        }
        if ((n3 & 0x40) != 0) {
            bl2 = mqttProperties.getClean();
        }
        if ((n3 & 0x80) != 0) {
            string5 = mqttProperties.getGroup();
        }
        if ((n3 & 0x100) != 0) {
            n2 = mqttProperties.getVersion();
        }
        return mqttProperties.copy(string, n, string2, string3, string4, bl, bl2, string5, n2);
    }

    @NotNull
    public String toString() {
        return "MqttProperties(host=" + this.getHost() + ", port=" + this.getPort() + ", clientId=" + this.getClientId() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", ssl=" + this.getSsl() + ", clean=" + this.getClean() + ", group=" + this.getGroup() + ", version=" + this.getVersion() + ')';
    }

    public int hashCode() {
        int result = this.getHost().hashCode();
        result = result * 31 + Integer.hashCode(this.getPort());
        result = result * 31 + (this.getClientId() == null ? 0 : this.getClientId().hashCode());
        result = result * 31 + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        result = result * 31 + (this.getPassword() == null ? 0 : this.getPassword().hashCode());
        int n = this.getSsl() ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        int n2 = this.getClean() ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result = result * 31 + n2;
        result = result * 31 + (this.getGroup() == null ? 0 : this.getGroup().hashCode());
        result = result * 31 + Integer.hashCode(this.getVersion());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MqttProperties)) {
            return false;
        }
        MqttProperties mqttProperties = (MqttProperties)other;
        if (!Intrinsics.areEqual((Object)this.getHost(), (Object)mqttProperties.getHost())) {
            return false;
        }
        if (this.getPort() != mqttProperties.getPort()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getClientId(), (Object)mqttProperties.getClientId())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getUsername(), (Object)mqttProperties.getUsername())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getPassword(), (Object)mqttProperties.getPassword())) {
            return false;
        }
        if (this.getSsl() != mqttProperties.getSsl()) {
            return false;
        }
        if (this.getClean() != mqttProperties.getClean()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getGroup(), (Object)mqttProperties.getGroup())) {
            return false;
        }
        return this.getVersion() == mqttProperties.getVersion();
    }

    public MqttProperties() {
        this(null, 0, null, null, null, false, false, null, 0, 511, null);
    }
}

