/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.starter.mqtt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.hivemq.client.mqtt.MqttClient;
import com.hivemq.client.mqtt.MqttClientBuilder;
import com.hivemq.client.mqtt.MqttClientBuilderBase;
import com.hivemq.client.mqtt.lifecycle.MqttClientConnectedContext;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedContext;
import com.hivemq.client.mqtt.mqtt3.Mqtt3Client;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientBuilder;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3Connect;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3ConnectBuilder;
import com.hivemq.client.mqtt.mqtt5.Mqtt5Client;
import com.hivemq.client.mqtt.mqtt5.Mqtt5ClientBuilder;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt5.message.connect.Mqtt5Connect;
import com.hivemq.client.mqtt.mqtt5.message.connect.Mqtt5ConnectBuilder;
import de.smartsquare.starter.mqtt.AnnotationCollector;
import de.smartsquare.starter.mqtt.Mqtt3ClientConfigurer;
import de.smartsquare.starter.mqtt.Mqtt3Publisher;
import de.smartsquare.starter.mqtt.Mqtt3Router;
import de.smartsquare.starter.mqtt.Mqtt5ClientConfigurer;
import de.smartsquare.starter.mqtt.Mqtt5Publisher;
import de.smartsquare.starter.mqtt.Mqtt5Router;
import de.smartsquare.starter.mqtt.MqttMessageAdapter;
import de.smartsquare.starter.mqtt.MqttProperties;
import de.smartsquare.starter.mqtt.SpringAwareMqtt3Client;
import de.smartsquare.starter.mqtt.SpringAwareMqtt5Client;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Configuration
@ConditionalOnClass(value={MqttClient.class})
@EnableConfigurationProperties(value={MqttProperties.class})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0017J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0017J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000fH\u0017J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000fH\u0017J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0011H\u0017J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u001aH\u0017J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u001aH\u0017R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/smartsquare/starter/mqtt/MqttAutoConfiguration;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "annotationCollector", "Lde/smartsquare/starter/mqtt/AnnotationCollector;", "configureCommon", "Lcom/hivemq/client/mqtt/MqttClientBuilder;", "config", "Lde/smartsquare/starter/mqtt/MqttProperties;", "messageAdapter", "Lde/smartsquare/starter/mqtt/MqttMessageAdapter;", "mqtt3Client", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3Client;", "configurers", "", "Lde/smartsquare/starter/mqtt/Mqtt3ClientConfigurer;", "mqtt3Publisher", "Lde/smartsquare/starter/mqtt/Mqtt3Publisher;", "client", "mqtt3Router", "Lde/smartsquare/starter/mqtt/Mqtt3Router;", "collector", "mqtt5Client", "Lcom/hivemq/client/mqtt/mqtt5/Mqtt5Client;", "Lde/smartsquare/starter/mqtt/Mqtt5ClientConfigurer;", "mqtt5Publisher", "Lde/smartsquare/starter/mqtt/Mqtt5Publisher;", "mqtt5Router", "Lde/smartsquare/starter/mqtt/Mqtt5Router;", "mqtt-starter"})
public class MqttAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean
    @ConditionalOnProperty(value={"mqtt.version"}, havingValue="3", matchIfMissing=true)
    @NotNull
    public Mqtt3Client mqtt3Client(@NotNull MqttProperties config, @NotNull List<? extends Mqtt3ClientConfigurer> configurers) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(configurers, (String)"configurers");
        Mqtt3ClientBuilder mqtt3ClientBuilder = this.configureCommon(config).useMqttVersion3();
        boolean bl = false;
        boolean bl2 = false;
        Mqtt3ClientBuilder $this$mqtt3Client_u24lambda_u2d2 = mqtt3ClientBuilder;
        boolean bl3 = false;
        String string = config.getUsername();
        if (string != null) {
            String string2 = string;
            boolean bl4 = false;
            boolean bl5 = false;
            String username = string2;
            boolean bl6 = false;
            String string3 = config.getPassword();
            if (string3 != null) {
                String string4 = string3;
                boolean bl7 = false;
                boolean bl8 = false;
                String password = string4;
                boolean bl9 = false;
                Mqtt3SimpleAuthBuilder.Nested.Complete complete = (Mqtt3SimpleAuthBuilder.Nested.Complete)$this$mqtt3Client_u24lambda_u2d2.simpleAuth().username(username);
                String string5 = password;
                Charset charset = Charsets.UTF_8;
                boolean bl10 = false;
                byte[] byArray = string5.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                ((Mqtt3SimpleAuthBuilder.Nested.Complete)complete.password(byArray)).applySimpleAuth();
            }
        }
        bl = false;
        bl2 = false;
        Mqtt3ClientBuilder $this$mqtt3Client_u24lambda_u2d4 = mqtt3ClientBuilder;
        boolean bl11 = false;
        Iterable $this$forEach$iv = configurers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Mqtt3ClientConfigurer configurer = (Mqtt3ClientConfigurer)element$iv;
            boolean bl12 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$mqtt3Client_u24lambda_u2d4, (String)"this");
            configurer.configure($this$mqtt3Client_u24lambda_u2d4);
        }
        Mqtt3ClientBuilder mqtt3ClientBuilder2 = mqtt3ClientBuilder;
        Intrinsics.checkNotNullExpressionValue((Object)mqtt3ClientBuilder2, (String)"configureCommon(config)\n            .useMqttVersion3()\n            .apply {\n                config.username?.let { username ->\n                    config.password?.let { password ->\n                        simpleAuth()\n                            .username(username)\n                            .password(password.toByteArray())\n                            .applySimpleAuth()\n                    }\n                }\n            }\n            .apply { configurers.forEach { configurer -> configurer.configure(this) } }");
        Mqtt3ClientBuilder clientBuilder = mqtt3ClientBuilder2;
        mqtt3ClientBuilder = ((Mqtt3ConnectBuilder)Mqtt3Connect.builder().cleanSession(config.getClean())).build();
        Intrinsics.checkNotNullExpressionValue((Object)mqtt3ClientBuilder, (String)"builder()\n            .cleanSession(config.clean)\n            .build()");
        Mqtt3ClientBuilder connectOptions = mqtt3ClientBuilder;
        mqtt3ClientBuilder = clientBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)mqtt3ClientBuilder, (String)"clientBuilder.build()");
        return new SpringAwareMqtt3Client((Mqtt3Client)mqtt3ClientBuilder, (Mqtt3Connect)connectOptions);
    }

    @Bean
    @ConditionalOnProperty(value={"mqtt.version"}, havingValue="5")
    @NotNull
    public Mqtt5Client mqtt5Client(@NotNull MqttProperties config, @NotNull List<? extends Mqtt5ClientConfigurer> configurers) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(configurers, (String)"configurers");
        Mqtt5ClientBuilder mqtt5ClientBuilder = this.configureCommon(config).useMqttVersion5();
        boolean bl = false;
        boolean bl2 = false;
        Mqtt5ClientBuilder $this$mqtt5Client_u24lambda_u2d7 = mqtt5ClientBuilder;
        boolean bl3 = false;
        String string = config.getUsername();
        if (string != null) {
            String string2 = string;
            boolean bl4 = false;
            boolean bl5 = false;
            String username = string2;
            boolean bl6 = false;
            String string3 = config.getPassword();
            if (string3 != null) {
                String string4 = string3;
                boolean bl7 = false;
                boolean bl8 = false;
                String password = string4;
                boolean bl9 = false;
                Mqtt5SimpleAuthBuilder.Nested.Complete complete = (Mqtt5SimpleAuthBuilder.Nested.Complete)$this$mqtt5Client_u24lambda_u2d7.simpleAuth().username(username);
                String string5 = password;
                Charset charset = Charsets.UTF_8;
                boolean bl10 = false;
                byte[] byArray = string5.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                ((Mqtt5SimpleAuthBuilder.Nested.Complete)complete.password(byArray)).applySimpleAuth();
            }
        }
        bl = false;
        bl2 = false;
        Mqtt5ClientBuilder $this$mqtt5Client_u24lambda_u2d9 = mqtt5ClientBuilder;
        boolean bl11 = false;
        Iterable $this$forEach$iv = configurers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Mqtt5ClientConfigurer configurer = (Mqtt5ClientConfigurer)element$iv;
            boolean bl12 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$mqtt5Client_u24lambda_u2d9, (String)"this");
            configurer.configure($this$mqtt5Client_u24lambda_u2d9);
        }
        Mqtt5ClientBuilder mqtt5ClientBuilder2 = mqtt5ClientBuilder;
        Intrinsics.checkNotNullExpressionValue((Object)mqtt5ClientBuilder2, (String)"configureCommon(config)\n            .useMqttVersion5()\n            .apply {\n                config.username?.let { username ->\n                    config.password?.let { password ->\n                        simpleAuth()\n                            .username(username)\n                            .password(password.toByteArray())\n                            .applySimpleAuth()\n                    }\n                }\n            }\n            .apply { configurers.forEach { configurer -> configurer.configure(this) } }");
        Mqtt5ClientBuilder clientBuilder = mqtt5ClientBuilder2;
        mqtt5ClientBuilder = ((Mqtt5ConnectBuilder)Mqtt5Connect.builder().cleanStart(config.getClean())).build();
        Intrinsics.checkNotNullExpressionValue((Object)mqtt5ClientBuilder, (String)"builder()\n            .cleanStart(config.clean)\n            .build()");
        Mqtt5ClientBuilder connectOptions = mqtt5ClientBuilder;
        mqtt5ClientBuilder = clientBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)mqtt5ClientBuilder, (String)"clientBuilder.build()");
        return new SpringAwareMqtt5Client((Mqtt5Client)mqtt5ClientBuilder, (Mqtt5Connect)connectOptions);
    }

    private final MqttClientBuilder configureCommon(MqttProperties config) {
        MqttClientBuilderBase mqttClientBuilderBase = ((MqttClientBuilder)((MqttClientBuilder)((MqttClientBuilder)((MqttClientBuilder)MqttClient.builder().serverHost(config.getHost())).serverPort(config.getPort())).automaticReconnectWithDefaultConfig()).addConnectedListener(arg_0 -> MqttAutoConfiguration.configureCommon$lambda-10(this, arg_0))).addDisconnectedListener(arg_0 -> MqttAutoConfiguration.configureCommon$lambda-11(this, arg_0));
        boolean bl = false;
        boolean bl2 = false;
        MqttClientBuilder $this$configureCommon_u24lambda_u2d12 = (MqttClientBuilder)mqttClientBuilderBase;
        boolean bl3 = false;
        if (config.getSsl()) {
            $this$configureCommon_u24lambda_u2d12.sslWithDefaultConfig();
        }
        MqttClientBuilderBase mqttClientBuilderBase2 = mqttClientBuilderBase;
        Intrinsics.checkNotNullExpressionValue((Object)mqttClientBuilderBase2, (String)"builder()\n            .serverHost(config.host)\n            .serverPort(config.port)\n            .automaticReconnectWithDefaultConfig()\n            .addConnectedListener { logger.info(\"Connected to broker.\") }\n            .addDisconnectedListener {\n                if (it.reconnector.isReconnect) {\n                    logger.warn(\"Disconnected from broker, reconnecting...\")\n                } else {\n                    logger.info(\"Disconnected from broker.\")\n                }\n            }\n            .apply { if (config.ssl) sslWithDefaultConfig() }");
        boolean bl4 = false;
        bl = false;
        MqttClientBuilder $this$configureCommon_u24lambda_u2d14 = (MqttClientBuilder)mqttClientBuilderBase2;
        boolean bl5 = false;
        String string = config.getClientId();
        if (string != null) {
            String string2 = string;
            boolean bl6 = false;
            boolean bl7 = false;
            String clientId = string2;
            boolean bl8 = false;
            $this$configureCommon_u24lambda_u2d14.identifier(clientId);
        }
        return (MqttClientBuilder)mqttClientBuilderBase2;
    }

    @Bean
    @NotNull
    public AnnotationCollector annotationCollector() {
        return new AnnotationCollector();
    }

    @Bean
    @NotNull
    public MqttMessageAdapter messageAdapter() {
        ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper().findAndRegisterModules();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"jacksonObjectMapper().findAndRegisterModules()");
        return new MqttMessageAdapter(objectMapper);
    }

    @Bean
    @ConditionalOnProperty(value={"mqtt.version"}, havingValue="3", matchIfMissing=true)
    @NotNull
    public Mqtt3Router mqtt3Router(@NotNull MqttMessageAdapter messageAdapter, @NotNull AnnotationCollector collector, @NotNull MqttProperties config, @NotNull Mqtt3Client client) {
        Intrinsics.checkNotNullParameter((Object)messageAdapter, (String)"messageAdapter");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return new Mqtt3Router(collector, messageAdapter, config, client);
    }

    @Bean
    @ConditionalOnProperty(value={"mqtt.version"}, havingValue="5")
    @NotNull
    public Mqtt5Router mqtt5Router(@NotNull MqttMessageAdapter messageAdapter, @NotNull AnnotationCollector collector, @NotNull MqttProperties config, @NotNull Mqtt5Client client) {
        Intrinsics.checkNotNullParameter((Object)messageAdapter, (String)"messageAdapter");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return new Mqtt5Router(collector, messageAdapter, config, client);
    }

    @Bean
    @ConditionalOnProperty(value={"mqtt.version"}, havingValue="3", matchIfMissing=true)
    @NotNull
    public Mqtt3Publisher mqtt3Publisher(@NotNull MqttMessageAdapter messageAdapter, @NotNull Mqtt3Client client) {
        Intrinsics.checkNotNullParameter((Object)messageAdapter, (String)"messageAdapter");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return new Mqtt3Publisher(messageAdapter, client);
    }

    @Bean
    @ConditionalOnProperty(value={"mqtt.version"}, havingValue="5")
    @NotNull
    public Mqtt5Publisher mqtt5Publisher(@NotNull MqttMessageAdapter messageAdapter, @NotNull Mqtt5Client client) {
        Intrinsics.checkNotNullParameter((Object)messageAdapter, (String)"messageAdapter");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return new Mqtt5Publisher(messageAdapter, client);
    }

    private static final void configureCommon$lambda-10(MqttAutoConfiguration this$0, MqttClientConnectedContext it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.logger.info("Connected to broker.");
    }

    private static final void configureCommon$lambda-11(MqttAutoConfiguration this$0, MqttClientDisconnectedContext it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getReconnector().isReconnect()) {
            this$0.logger.warn("Disconnected from broker, reconnecting...");
        } else {
            this$0.logger.info("Disconnected from broker.");
        }
    }
}

