/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.starter.mqtt;

import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.mqtt5.Mqtt5AsyncClient;
import com.hivemq.client.mqtt.mqtt5.Mqtt5Client;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5Publish;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PublishBuilder;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PublishResult;
import de.smartsquare.starter.mqtt.MqttMessageAdapter;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/smartsquare/starter/mqtt/Mqtt5Publisher;", "", "adapter", "Lde/smartsquare/starter/mqtt/MqttMessageAdapter;", "client", "Lcom/hivemq/client/mqtt/mqtt5/Mqtt5Client;", "(Lde/smartsquare/starter/mqtt/MqttMessageAdapter;Lcom/hivemq/client/mqtt/mqtt5/Mqtt5Client;)V", "asyncClient", "Lcom/hivemq/client/mqtt/mqtt5/Mqtt5AsyncClient;", "Lorg/jetbrains/annotations/NotNull;", "publish", "Ljava/util/concurrent/CompletableFuture;", "Lcom/hivemq/client/mqtt/mqtt5/message/publish/Mqtt5PublishResult;", "topic", "", "qos", "Lcom/hivemq/client/mqtt/datatypes/MqttQos;", "payload", "mqtt-starter"})
public final class Mqtt5Publisher {
    @NotNull
    private final MqttMessageAdapter adapter;
    @NotNull
    private final Mqtt5AsyncClient asyncClient;

    public Mqtt5Publisher(@NotNull MqttMessageAdapter adapter, @NotNull Mqtt5Client client) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.adapter = adapter;
        Mqtt5AsyncClient mqtt5AsyncClient = client.toAsync();
        Intrinsics.checkNotNullExpressionValue((Object)mqtt5AsyncClient, (String)"client.toAsync()");
        this.asyncClient = mqtt5AsyncClient;
    }

    @NotNull
    public final CompletableFuture<Mqtt5PublishResult> publish(@NotNull String topic, @NotNull MqttQos qos, @NotNull Object payload) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)qos, (String)"qos");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        CompletableFuture completableFuture = this.asyncClient.publish(((Mqtt5PublishBuilder.Complete)((Mqtt5PublishBuilder.Complete)((Mqtt5PublishBuilder.Complete)Mqtt5Publish.builder().topic(topic)).qos(qos)).payload(this.adapter.adapt(payload))).build());
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"asyncClient.publish(\n            Mqtt5Publish.builder()\n                .topic(topic)\n                .qos(qos)\n                .payload(adapter.adapt(payload))\n                .build()\n        )");
        return completableFuture;
    }
}

