/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.starter.mqtt;

import com.hivemq.client.mqtt.mqtt3.Mqtt3AsyncClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3Client;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import de.smartsquare.starter.mqtt.AnnotationCollector;
import de.smartsquare.starter.mqtt.MqttMessageAdapter;
import de.smartsquare.starter.mqtt.MqttProperties;
import de.smartsquare.starter.mqtt.MqttSubscribe;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/smartsquare/starter/mqtt/MqttRouter;", "Lorg/springframework/beans/factory/InitializingBean;", "collector", "Lde/smartsquare/starter/mqtt/AnnotationCollector;", "adapter", "Lde/smartsquare/starter/mqtt/MqttMessageAdapter;", "config", "Lde/smartsquare/starter/mqtt/MqttProperties;", "client", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3Client;", "(Lde/smartsquare/starter/mqtt/AnnotationCollector;Lde/smartsquare/starter/mqtt/MqttMessageAdapter;Lde/smartsquare/starter/mqtt/MqttProperties;Lcom/hivemq/client/mqtt/mqtt3/Mqtt3Client;)V", "asyncClient", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3AsyncClient;", "Lorg/jetbrains/annotations/NotNull;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "afterPropertiesSet", "", "deliver", "subscriber", "Ljava/lang/reflect/Method;", "bean", "", "message", "Lcom/hivemq/client/mqtt/mqtt3/message/publish/Mqtt3Publish;", "mqtt-starter"})
public final class MqttRouter
implements InitializingBean {
    @NotNull
    private final AnnotationCollector collector;
    @NotNull
    private final MqttMessageAdapter adapter;
    @NotNull
    private final MqttProperties config;
    private final Logger logger;
    @NotNull
    private final Mqtt3AsyncClient asyncClient;

    public MqttRouter(@NotNull AnnotationCollector collector, @NotNull MqttMessageAdapter adapter, @NotNull MqttProperties config, @NotNull Mqtt3Client client) {
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.collector = collector;
        this.adapter = adapter;
        this.config = config;
        this.logger = LoggerFactory.getLogger(this.getClass());
        Mqtt3AsyncClient mqtt3AsyncClient = client.toAsync();
        Intrinsics.checkNotNullExpressionValue((Object)mqtt3AsyncClient, (String)"client.toAsync()");
        this.asyncClient = mqtt3AsyncClient;
    }

    public void afterPropertiesSet() {
        Iterator iterator = this.collector.getSubscribers();
        boolean bl = false;
        Iterator<Map.Entry<Object, List<Method>>> iterator2 = iterator.entrySet().iterator();
        while (iterator2.hasNext()) {
            Iterator iterator3 = iterator = iterator2.next();
            boolean bl2 = false;
            Object bean = iterator3.getKey();
            Iterator iterator4 = iterator;
            boolean bl3 = false;
            List subscribers = (List)iterator4.getValue();
            for (Method subscriber : subscribers) {
                MqttSubscribe annotation = subscriber.getAnnotation(MqttSubscribe.class);
                String topic = annotation.shared() && this.config.getGroup() != null ? "$share/" + this.config.getGroup() + '/' + annotation.topic() : annotation.topic();
                ((Mqtt3AsyncClient.Mqtt3SubscribeAndCallbackBuilder.Start.Complete)((Mqtt3AsyncClient.Mqtt3SubscribeAndCallbackBuilder.Start.Complete)this.asyncClient.subscribeWith().topicFilter(topic)).qos(annotation.qos())).callback(arg_0 -> MqttRouter.afterPropertiesSet$lambda-0(this, subscriber, bean, arg_0)).send();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void deliver(Method subscriber, Object bean, Mqtt3Publish message) {
        try {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Class<?>[] classArray = subscriber.getParameterTypes();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"subscriber.parameterTypes");
            Object $this$map$iv = classArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((Object[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Class clazz = (Class)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Object t = this.adapter.adapt(message, it);
                collection.add(t);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray2 = thisCollection$iv.toArray(new Object[0]);
            if (objectArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] parameters = objectArray2;
            subscriber.invoke(bean, Arrays.copyOf(parameters, parameters.length));
        }
        catch (InvocationTargetException e) {
            this.logger.error("Error while delivering mqtt message.", (Throwable)e);
        }
    }

    private static final void afterPropertiesSet$lambda-0(MqttRouter this$0, Method $subscriber, Object $bean, Mqtt3Publish message) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$subscriber, (String)"$subscriber");
        Intrinsics.checkNotNullParameter((Object)$bean, (String)"$bean");
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
        this$0.deliver($subscriber, $bean, message);
    }
}

