/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.starter.mqtt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hivemq.client.mqtt.datatypes.MqttTopic;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0005\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/smartsquare/starter/mqtt/MqttMessageAdapter;", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "adapt", "T", "message", "Lcom/hivemq/client/mqtt/mqtt3/message/publish/Mqtt3Publish;", "targetType", "Ljava/lang/Class;", "(Lcom/hivemq/client/mqtt/mqtt3/message/publish/Mqtt3Publish;Ljava/lang/Class;)Ljava/lang/Object;", "", "payload", "mqtt-starter"})
public final class MqttMessageAdapter {
    @NotNull
    private final ObjectMapper objectMapper;

    public MqttMessageAdapter(@NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.objectMapper = objectMapper;
    }

    public final <T> T adapt(@NotNull Mqtt3Publish message, @NotNull Class<T> targetType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(targetType, (String)"targetType");
        if (targetType.isAssignableFrom(MqttTopic.class)) {
            object = message.getTopic();
        } else if (targetType.isAssignableFrom(String.class)) {
            byte[] byArray = message.getPayloadAsBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"message.payloadAsBytes");
            object = StringsKt.decodeToString((byte[])byArray);
        } else {
            object = this.objectMapper.readValue(message.getPayloadAsBytes(), targetType);
        }
        return (T)object;
    }

    @NotNull
    public final byte[] adapt(@NotNull Object payload) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Object object = payload;
        if (object instanceof String) {
            byArray = StringsKt.encodeToByteArray((String)((String)payload));
        } else {
            String string = this.objectMapper.writeValueAsString(payload);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"objectMapper.writeValueAsString(payload)");
            byArray = StringsKt.encodeToByteArray((String)string);
        }
        return byArray;
    }
}

