/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.starter.mqtt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.hivemq.client.mqtt.MqttClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3Client;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientBuilder;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt3.message.connect.connack.Mqtt3ConnAck;
import de.smartsquare.starter.mqtt.AnnotationCollector;
import de.smartsquare.starter.mqtt.BrokerConnectException;
import de.smartsquare.starter.mqtt.MqttMessageAdapter;
import de.smartsquare.starter.mqtt.MqttProperties;
import de.smartsquare.starter.mqtt.MqttPublisher;
import de.smartsquare.starter.mqtt.MqttRouter;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MqttClient.class})
@EnableConfigurationProperties(value={MqttProperties.class})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0017J\b\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000bH\u0017J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000bH\u0017R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/smartsquare/starter/mqtt/MqttAutoConfiguration;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "annotationCollector", "Lde/smartsquare/starter/mqtt/AnnotationCollector;", "messageAdapter", "Lde/smartsquare/starter/mqtt/MqttMessageAdapter;", "mqttClient", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3Client;", "config", "Lde/smartsquare/starter/mqtt/MqttProperties;", "publisher", "Lde/smartsquare/starter/mqtt/MqttPublisher;", "client", "router", "Lde/smartsquare/starter/mqtt/MqttRouter;", "collector", "mqtt-starter"})
public class MqttAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean
    @NotNull
    public Mqtt3Client mqttClient(@NotNull MqttProperties config) {
        Mqtt3Client mqtt3Client;
        Mqtt3ClientBuilder builder;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Mqtt3SimpleAuthBuilder.Nested.Complete complete = (Mqtt3SimpleAuthBuilder.Nested.Complete)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)Mqtt3Client.builder().serverHost(config.getHost())).serverPort(config.getPort())).automaticReconnectWithDefaultConfig()).simpleAuth().username(config.getUsername());
        String string = config.getPassword();
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        Mqtt3ClientBuilder baseClient = (Mqtt3ClientBuilder)((Mqtt3SimpleAuthBuilder.Nested.Complete)complete.password(byArray)).applySimpleAuth();
        Mqtt3ClientBuilder mqtt3ClientBuilder = builder = config.getSsl() ? (Mqtt3ClientBuilder)baseClient.sslWithDefaultConfig() : baseClient;
        if (config.getClientId() != null) {
            String string3 = config.getClientId();
            Intrinsics.checkNotNull((Object)string3);
            mqtt3Client = ((Mqtt3ClientBuilder)builder.identifier(string3)).build();
        } else {
            mqtt3Client = builder.build();
        }
        Mqtt3Client mqtt3Client2 = mqtt3Client;
        Intrinsics.checkNotNullExpressionValue((Object)mqtt3Client2, (String)"if (config.clientId != null) {\n            builder.identifier(config.clientId!!).build()\n        } else {\n            builder.build()\n        }");
        Mqtt3Client client = mqtt3Client2;
        this.logger.info("Connecting to " + config.getUsername() + '@' + config.getHost() + ':' + config.getPort() + "...");
        try {
            Mqtt3ConnAck acknowledgement = (Mqtt3ConnAck)client.toAsync().connect().get(10L, TimeUnit.SECONDS);
            if (acknowledgement.getReturnCode().isError()) {
                Intrinsics.checkNotNullExpressionValue((Object)acknowledgement, (String)"acknowledgement");
                throw new BrokerConnectException(acknowledgement, null, 2, null);
            }
            this.logger.info("Successfully connected to broker.");
            return client;
        }
        catch (TimeoutException e) {
            throw new BrokerConnectException("Broker " + config.getHost() + ':' + config.getPort() + " did not respond within 10 seconds.", (Throwable)e);
        }
    }

    @Bean
    @NotNull
    public AnnotationCollector annotationCollector() {
        return new AnnotationCollector();
    }

    @Bean
    @NotNull
    public MqttMessageAdapter messageAdapter() {
        ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper().findAndRegisterModules();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"jacksonObjectMapper().findAndRegisterModules()");
        return new MqttMessageAdapter(objectMapper);
    }

    @Bean
    @NotNull
    public MqttRouter router(@NotNull MqttMessageAdapter messageAdapter, @NotNull AnnotationCollector collector, @NotNull MqttProperties config, @NotNull Mqtt3Client client) {
        Intrinsics.checkNotNullParameter((Object)messageAdapter, (String)"messageAdapter");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return new MqttRouter(collector, messageAdapter, config, client);
    }

    @Bean
    @NotNull
    public MqttPublisher publisher(@NotNull MqttMessageAdapter messageAdapter, @NotNull Mqtt3Client client) {
        Intrinsics.checkNotNullParameter((Object)messageAdapter, (String)"messageAdapter");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return new MqttPublisher(messageAdapter, client);
    }
}

