/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.starter.mqtt;

import com.hivemq.client.mqtt.datatypes.MqttTopic;
import de.smartsquare.starter.mqtt.MqttConfigurationException;
import de.smartsquare.starter.mqtt.MqttSubscribe;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0007H\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lde/smartsquare/starter/mqtt/AnnotationCollector;", "Lorg/springframework/beans/factory/config/BeanPostProcessor;", "()V", "_subscribers", "", "", "", "Ljava/lang/reflect/Method;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "subscribers", "", "getSubscribers", "()Ljava/util/Map;", "postProcessBeforeInitialization", "bean", "beanName", "", "isInvalidSignature", "", "mqtt-starter"})
public final class AnnotationCollector
implements BeanPostProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private final Map<Object, List<Method>> _subscribers;

    public AnnotationCollector() {
        boolean bl = false;
        this._subscribers = new LinkedHashMap();
    }

    @NotNull
    public final Map<Object, List<Method>> getSubscribers() {
        return this._subscribers;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Object postProcessBeforeInitialization(@NotNull Object bean, @NotNull String beanName) {
        void $this$filterTo$iv$iv;
        void $this$sortedBy$iv;
        void $this$filterTo$iv$iv22;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
        Object[] objectArray = bean.getClass().getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"bean.javaClass.methods");
        objectArray = objectArray;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv22) {
            Method it = (Method)element$iv$iv;
            boolean bl = false;
            if (!it.isAnnotationPresent(MqttSubscribe.class)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        boolean $this$filterTo$iv$iv22 = false;
        List collectedSubscribers = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Method it = (Method)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Method)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        Iterable $this$filter$iv2 = collectedSubscribers;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Method it = (Method)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!this.isInvalidSignature(it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List erroneousSubscriberDefinitions = (List)destination$iv$iv2;
        $this$filter$iv2 = erroneousSubscriberDefinitions;
        $i$f$filter2 = false;
        if (!$this$filter$iv2.isEmpty()) {
            String joinedSubscribers2 = CollectionsKt.joinToString$default((Iterable)erroneousSubscriberDefinitions, (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<Method, CharSequence>(beanName){
                final /* synthetic */ String $beanName;
                {
                    this.$beanName = $beanName;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(Method it) {
                    return this.$beanName + '#' + it.getName();
                }
            }), (int)30, null);
            throw new MqttConfigurationException(StringsKt.trimMargin$default((String)("Following subscribers are invalid [" + joinedSubscribers2 + "].\n                   Functions annotated with 'MqttSubscriber' can only have the following parameters:\n                     - the MqttTopic\n                     - any type of deserialized JSON payload\n                     - or both\n                "), null, (int)1, null));
        }
        for (Method subscriber : collectedSubscribers) {
            this.logger.debug("Found subscriber " + subscriber.getName() + " of " + bean.getClass().getSimpleName() + '.');
            Map<Object, List<Method>> map = this._subscribers;
            List list = CollectionsKt.plus((Collection)this.getSubscribers().getOrDefault(bean, CollectionsKt.emptyList()), (Iterable)CollectionsKt.listOf((Object)subscriber));
            boolean bl = false;
            map.put(bean, list);
        }
        return bean;
    }

    private final boolean isInvalidSignature(Method $this$isInvalidSignature) {
        Class<?>[] classArray = $this$isInvalidSignature.getParameterTypes();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"this.parameterTypes");
        Object[] $this$count$iv = classArray;
        boolean $i$f$count22 = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            Class it = (Class)element$iv;
            boolean bl = false;
            if (!it.isAssignableFrom(MqttTopic.class)) continue;
            ++count$iv;
        }
        int topicParamCount = count$iv;
        Class<?>[] $i$f$count22 = $this$isInvalidSignature.getParameterTypes();
        Intrinsics.checkNotNullExpressionValue($i$f$count22, (String)"this.parameterTypes");
        Object[] $this$count$iv2 = $i$f$count22;
        boolean $i$f$count = false;
        int count$iv2 = 0;
        for (Object element$iv : $this$count$iv2) {
            Class it = (Class)element$iv;
            boolean bl = false;
            if (!(!it.isAssignableFrom(MqttTopic.class))) continue;
            ++count$iv2;
        }
        int payloadParamCount = count$iv2;
        return topicParamCount > 1 || payloadParamCount > 1;
    }
}

