/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.starter.mqttadmin.emqx;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.smartsquare.starter.mqttadmin.emqx.EmqxApiClient;
import de.smartsquare.starter.mqttadmin.emqx.EmqxApiProperties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={EmqxApiProperties.class})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0017\u00a8\u0006\u000b"}, d2={"Lde/smartsquare/starter/mqttadmin/emqx/EmqxApiConfiguration;", "", "()V", "emqxApiClient", "Lde/smartsquare/starter/mqttadmin/emqx/EmqxApiClient;", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "config", "Lde/smartsquare/starter/mqttadmin/emqx/EmqxApiProperties;", "mqtt-admin-starter"})
public class EmqxApiConfiguration {
    @Bean
    @Qualifier(value="emqx")
    @NotNull
    public RestTemplate restTemplate(@NotNull EmqxApiProperties config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        RestTemplate restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).rootUri("http://" + config.getHost() + ':' + config.getPort()).basicAuthentication(config.getUsername(), config.getPassword()).build();
        Intrinsics.checkNotNullExpressionValue((Object)restTemplate, (String)"RestTemplateBuilder()\n  \u2026assword)\n        .build()");
        return restTemplate;
    }

    @Bean
    @NotNull
    public EmqxApiClient emqxApiClient(@Qualifier(value="emqx") @NotNull RestTemplate restTemplate, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)restTemplate, (String)"restTemplate");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        return new EmqxApiClient(restTemplate, objectMapper);
    }
}

