/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.starter.mqttadmin.emqx;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import de.smartsquare.starter.mqttadmin.client.AclRule;
import de.smartsquare.starter.mqttadmin.client.BrokerApiClient;
import de.smartsquare.starter.mqttadmin.client.ClientActionResult;
import de.smartsquare.starter.mqttadmin.client.ClientData;
import de.smartsquare.starter.mqttadmin.emqx.EmqxApiRequestResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001&B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J!\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0016J\u0016\u0010\u0014\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u001c\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00162\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J)\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u000e\u0010#\u001a\u0004\u0018\u00010\u001a*\u00020$H\u0002J\f\u0010%\u001a\u00020\u001a*\u00020\u000eH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lde/smartsquare/starter/mqttadmin/emqx/EmqxApiClient;", "Lde/smartsquare/starter/mqttadmin/client/BrokerApiClient;", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lorg/springframework/web/client/RestTemplate;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "aclRuleUrl", "", "authClientUrl", "addAclRules", "Lde/smartsquare/starter/mqttadmin/client/ClientActionResult;", "aclRule", "", "Lde/smartsquare/starter/mqttadmin/client/AclRule;", "([Lde/smartsquare/starter/mqttadmin/client/AclRule;)Lde/smartsquare/starter/mqttadmin/client/ClientActionResult;", "deleteAclRules", "", "clientId", "topic", "evaluateResult", "result", "Lde/smartsquare/starter/mqttadmin/emqx/EmqxApiRequestResult;", "", "getAclRules", "", "Lde/smartsquare/starter/mqttadmin/emqx/EmqxApiClient$AclRuleDto;", "post", "url", "data", "registerClient", "clientData", "Lde/smartsquare/starter/mqttadmin/client/ClientData;", "(Lde/smartsquare/starter/mqttadmin/client/ClientData;[Lde/smartsquare/starter/mqttadmin/client/AclRule;)Lde/smartsquare/starter/mqttadmin/client/ClientActionResult;", "unregisterClient", "convertToAclRuleDto", "Lcom/fasterxml/jackson/databind/JsonNode;", "convertToTransferObject", "AclRuleDto", "mqtt-admin-starter"})
public class EmqxApiClient
implements BrokerApiClient {
    private final String authClientUrl;
    private final String aclRuleUrl;
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ClientActionResult registerClient(@NotNull ClientData clientData, AclRule ... aclRule) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)clientData, (String)"clientData");
        Intrinsics.checkNotNullParameter((Object)aclRule, (String)"aclRule");
        try {
            this.post(this.authClientUrl, clientData);
            object = aclRule;
            boolean bl = false;
            Object object2 = object;
            boolean bl2 = false;
            if (!(((AclRule[])object2).length == 0)) {
                Collection<AclRuleDto> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                object = aclRule;
                String string = this.aclRuleUrl;
                EmqxApiClient emqxApiClient = this;
                boolean $i$f$map = false;
                object2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                void var8_12 = $this$mapTo$iv$iv;
                int n = ((void)var8_12).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var12_16 = item$iv$iv = var8_12[i];
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    AclRuleDto aclRuleDto = this.convertToTransferObject((AclRule)it);
                    collection.add(aclRuleDto);
                }
                collection = (List)destination$iv$iv;
                emqxApiClient.post(string, collection);
            }
            object = new ClientActionResult(true, null, 2, null);
        }
        catch (RestClientException e) {
            object = new ClientActionResult(false, e.getMessage());
        }
        return object;
    }

    @Override
    @NotNull
    public ClientActionResult unregisterClient(@NotNull String clientId) {
        ClientActionResult clientActionResult;
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        try {
            this.restTemplate.delete(this.authClientUrl + '/' + clientId, new Object[0]);
            this.deleteAclRules(clientId);
            clientActionResult = new ClientActionResult(true, null, 2, null);
        }
        catch (RestClientException e) {
            clientActionResult = new ClientActionResult(false, e.getMessage());
        }
        return clientActionResult;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ClientActionResult addAclRules(AclRule ... aclRule) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)aclRule, (String)"aclRule");
        try {
            object = aclRule;
            boolean bl = false;
            AclRule[] aclRuleArray = object;
            boolean bl2 = false;
            if (!(aclRuleArray.length == 0)) {
                Collection<AclRuleDto> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                object = aclRule;
                String string = this.aclRuleUrl;
                EmqxApiClient emqxApiClient = this;
                boolean $i$f$map = false;
                aclRuleArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                void var7_11 = $this$mapTo$iv$iv;
                int n = ((void)var7_11).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var11_15 = item$iv$iv = var7_11[i];
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    AclRuleDto aclRuleDto = this.convertToTransferObject((AclRule)it);
                    collection.add(aclRuleDto);
                }
                collection = (List)destination$iv$iv;
                emqxApiClient.post(string, collection);
            }
            object = new ClientActionResult(true, null, 2, null);
        }
        catch (RestClientException e) {
            object = new ClientActionResult(false, e.getMessage());
        }
        return object;
    }

    @Override
    @NotNull
    public ClientActionResult deleteAclRules(@NotNull String clientId, @NotNull String topic) {
        ClientActionResult clientActionResult;
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        try {
            this.restTemplate.delete(this.aclRuleUrl + '/' + clientId + "/{topic}", new Object[]{topic});
            clientActionResult = new ClientActionResult(true, null, 2, null);
        }
        catch (RestClientException e) {
            clientActionResult = new ClientActionResult(false, e.getMessage());
        }
        return clientActionResult;
    }

    private final void deleteAclRules(String clientId) {
        List<AclRuleDto> list = this.getAclRules(clientId).getData();
        Intrinsics.checkNotNull(list);
        List<AclRuleDto> aclRules = list;
        for (AclRuleDto aclRule : aclRules) {
            this.restTemplate.delete(this.aclRuleUrl + '/' + clientId + "/{topic}", new Object[]{aclRule.getTopic()});
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void post(String url, Object data) {
        void request$iv;
        void $this$postForObject$iv;
        void uriVariables$iv;
        RestOperations restOperations = (RestOperations)this.restTemplate;
        String string = this.objectMapper.writeValueAsString(data);
        Object[] objectArray = new Object[]{};
        boolean $i$f$postForObject = false;
        void v0 = uriVariables$iv;
        Object object = $this$postForObject$iv.postForObject(url, (Object)request$iv, EmqxApiRequestResult.class, (Object[])Arrays.copyOf(v0, ((void)v0).length));
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type de.smartsquare.starter.mqttadmin.emqx.EmqxApiRequestResult<kotlin.Any>");
        }
        EmqxApiRequestResult result = (EmqxApiRequestResult)object;
        this.evaluateResult(result);
    }

    /*
     * WARNING - void declaration
     */
    private final EmqxApiRequestResult<List<AclRuleDto>> getAclRules(String clientId) {
        EmqxApiRequestResult emqxApiRequestResult;
        void url$iv;
        Iterable $this$getForObject$iv;
        RestOperations restOperations = (RestOperations)this.restTemplate;
        String string = this.aclRuleUrl + '/' + clientId;
        Object[] uriVariables$iv = new Object[]{};
        boolean $i$f$getForObject = false;
        Object object = $this$getForObject$iv.getForObject((String)url$iv, JsonNode.class, Arrays.copyOf(uriVariables$iv, uriVariables$iv.length));
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.JsonNode");
        }
        JsonNode result = ((JsonNode)object).get("data");
        JsonNode jsonNode = result;
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"result");
        if (jsonNode.getNodeType() == JsonNodeType.ARRAY) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            $this$getForObject$iv = (Iterable)result;
            String string2 = null;
            Integer n = 0;
            boolean $i$f$mapNotNull = false;
            uriVariables$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                AclRuleDto aclRuleDto;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                JsonNode it = (JsonNode)element$iv$iv;
                boolean bl2 = false;
                JsonNode jsonNode2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode2, (String)"it");
                if (this.convertToAclRuleDto(jsonNode2) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                AclRuleDto it$iv$iv = aclRuleDto;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n2 = 2;
            List list2 = list;
            String string3 = string2;
            Integer n3 = n;
            emqxApiRequestResult = new EmqxApiRequestResult(n3, string3, list2, n2, defaultConstructorMarker);
        } else if (result.getNodeType() == JsonNodeType.OBJECT && result.hasNonNull("topic")) {
            Integer n = 0;
            AclRuleDto aclRuleDto = this.convertToAclRuleDto(result);
            Intrinsics.checkNotNull((Object)aclRuleDto);
            emqxApiRequestResult = new EmqxApiRequestResult(n, null, CollectionsKt.listOf((Object)aclRuleDto), 2, null);
        } else {
            emqxApiRequestResult = new EmqxApiRequestResult(0, null, CollectionsKt.emptyList(), 2, null);
        }
        return emqxApiRequestResult;
    }

    private final void evaluateResult(EmqxApiRequestResult<Object> result) {
        block5: {
            block4: {
                if (result.getCode() == null) break block4;
                Integer n = result.getCode();
                if (n != null && n == 0) break block5;
            }
            if (result.getMessage() != null) {
                throw (Throwable)new RestClientException(result.getMessage());
            }
            throw (Throwable)new RestClientException("An error occurred.");
        }
    }

    private final AclRuleDto convertToTransferObject(AclRule $this$convertToTransferObject) {
        return new AclRuleDto($this$convertToTransferObject.getLogin(), $this$convertToTransferObject.getTopic(), $this$convertToTransferObject.getAction().getAction(), $this$convertToTransferObject.getAllow());
    }

    private final AclRuleDto convertToAclRuleDto(JsonNode $this$convertToAclRuleDto) {
        ObjectMapper $this$treeToValue$iv = this.objectMapper;
        boolean $i$f$treeToValue = false;
        return (AclRuleDto)$this$treeToValue$iv.treeToValue((TreeNode)$this$convertToAclRuleDto, AclRuleDto.class);
    }

    public EmqxApiClient(@Qualifier(value="emqx") @NotNull RestTemplate restTemplate, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)restTemplate, (String)"restTemplate");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
        this.authClientUrl = "/api/v4/auth_username";
        this.aclRuleUrl = "/api/v4/mqtt_acl";
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0019"}, d2={"Lde/smartsquare/starter/mqttadmin/emqx/EmqxApiClient$AclRuleDto;", "", "login", "", "topic", "action", "allow", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "getAction", "()Ljava/lang/String;", "getAllow", "()Z", "getLogin", "getTopic", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "mqtt-admin-starter"})
    private static final class AclRuleDto {
        @NotNull
        private final String login;
        @NotNull
        private final String topic;
        @NotNull
        private final String action;
        private final boolean allow;

        @NotNull
        public final String getLogin() {
            return this.login;
        }

        @NotNull
        public final String getTopic() {
            return this.topic;
        }

        @NotNull
        public final String getAction() {
            return this.action;
        }

        public final boolean getAllow() {
            return this.allow;
        }

        public AclRuleDto(@NotNull String login, @NotNull String topic, @NotNull String action, boolean allow) {
            Intrinsics.checkNotNullParameter((Object)login, (String)"login");
            Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            this.login = login;
            this.topic = topic;
            this.action = action;
            this.allow = allow;
        }

        @NotNull
        public final String component1() {
            return this.login;
        }

        @NotNull
        public final String component2() {
            return this.topic;
        }

        @NotNull
        public final String component3() {
            return this.action;
        }

        public final boolean component4() {
            return this.allow;
        }

        @NotNull
        public final AclRuleDto copy(@NotNull String login, @NotNull String topic, @NotNull String action, boolean allow) {
            Intrinsics.checkNotNullParameter((Object)login, (String)"login");
            Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            return new AclRuleDto(login, topic, action, allow);
        }

        public static /* synthetic */ AclRuleDto copy$default(AclRuleDto aclRuleDto, String string, String string2, String string3, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = aclRuleDto.login;
            }
            if ((n & 2) != 0) {
                string2 = aclRuleDto.topic;
            }
            if ((n & 4) != 0) {
                string3 = aclRuleDto.action;
            }
            if ((n & 8) != 0) {
                bl = aclRuleDto.allow;
            }
            return aclRuleDto.copy(string, string2, string3, bl);
        }

        @NotNull
        public String toString() {
            return "AclRuleDto(login=" + this.login + ", topic=" + this.topic + ", action=" + this.action + ", allow=" + this.allow + ")";
        }

        public int hashCode() {
            String string = this.login;
            String string2 = this.topic;
            String string3 = this.action;
            int n = (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31;
            int n2 = this.allow ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof AclRuleDto)) break block3;
                    AclRuleDto aclRuleDto = (AclRuleDto)object;
                    if (!Intrinsics.areEqual((Object)this.login, (Object)aclRuleDto.login) || !Intrinsics.areEqual((Object)this.topic, (Object)aclRuleDto.topic) || !Intrinsics.areEqual((Object)this.action, (Object)aclRuleDto.action) || this.allow != aclRuleDto.allow) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

