/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.starter.mqttadmin.client;

import de.smartsquare.starter.mqttadmin.client.AclRule;
import de.smartsquare.starter.mqttadmin.client.BrokerApiClient;
import de.smartsquare.starter.mqttadmin.client.ClientActionResult;
import de.smartsquare.starter.mqttadmin.client.ClientData;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J/\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\f\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/smartsquare/starter/mqttadmin/client/ClientService;", "", "brokerApiClient", "Lde/smartsquare/starter/mqttadmin/client/BrokerApiClient;", "(Lde/smartsquare/starter/mqttadmin/client/BrokerApiClient;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "addAclRules", "Lde/smartsquare/starter/mqttadmin/client/ClientActionResult;", "aclRule", "", "Lde/smartsquare/starter/mqttadmin/client/AclRule;", "([Lde/smartsquare/starter/mqttadmin/client/AclRule;)Lde/smartsquare/starter/mqttadmin/client/ClientActionResult;", "deleteAclRules", "clientId", "", "topic", "registerClient", "password", "(Ljava/lang/String;Ljava/lang/String;[Lde/smartsquare/starter/mqttadmin/client/AclRule;)Lde/smartsquare/starter/mqttadmin/client/ClientActionResult;", "unregisterClient", "mqtt-admin-starter"})
public class ClientService {
    private final Logger logger;
    private final BrokerApiClient brokerApiClient;

    @NotNull
    public final ClientActionResult registerClient(@NotNull String clientId, @NotNull String password, AclRule ... aclRule) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)aclRule, (String)"aclRule");
        ClientActionResult result = this.brokerApiClient.registerClient(new ClientData(clientId, password), Arrays.copyOf(aclRule, aclRule.length));
        if (result.getSuccess()) {
            AclRule[] aclRuleArray = aclRule;
            boolean bl = false;
            if (aclRuleArray.length == 0) {
                this.logger.debug("Registered client " + clientId + " without any acl rule.");
            }
        }
        return result;
    }

    @NotNull
    public final ClientActionResult unregisterClient(@NotNull String clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        return this.brokerApiClient.unregisterClient(clientId);
    }

    @NotNull
    public final ClientActionResult addAclRules(AclRule ... aclRule) {
        Intrinsics.checkNotNullParameter((Object)aclRule, (String)"aclRule");
        return this.brokerApiClient.addAclRules(Arrays.copyOf(aclRule, aclRule.length));
    }

    @NotNull
    public final ClientActionResult deleteAclRules(@NotNull String clientId, @NotNull String topic) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return this.brokerApiClient.deleteAclRules(clientId, topic);
    }

    public ClientService(@NotNull BrokerApiClient brokerApiClient) {
        Intrinsics.checkNotNullParameter((Object)brokerApiClient, (String)"brokerApiClient");
        this.brokerApiClient = brokerApiClient;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

