/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.starter.mqttadmin.emqx;

import de.smartsquare.starter.mqttadmin.emqx.EmqxApiException;
import de.smartsquare.starter.mqttadmin.emqx.EmqxApiRequestResult;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J+\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\n\"\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ\"\u0010\r\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\u00110\u0010H\u0002JG\u0010\u0012\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\u00110\u00142\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\n\"\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J3\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\n\"\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/smartsquare/starter/mqttadmin/emqx/EmqxHttpClient;", "", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "(Lorg/springframework/web/client/RestTemplate;)V", "delete", "", "url", "", "variables", "", "delete$mqtt_admin_starter", "(Ljava/lang/String;[Ljava/lang/Object;)V", "evaluateResult", "T", "result", "Lorg/springframework/http/ResponseEntity;", "Lde/smartsquare/starter/mqttadmin/emqx/EmqxApiRequestResult;", "get", "typeRef", "Lorg/springframework/core/ParameterizedTypeReference;", "get$mqtt_admin_starter", "(Ljava/lang/String;Lorg/springframework/core/ParameterizedTypeReference;[Ljava/lang/Object;)Ljava/lang/Object;", "post", "data", "post$mqtt_admin_starter", "(Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/Object;)V", "mqtt-admin-starter"})
public final class EmqxHttpClient {
    @NotNull
    private final RestTemplate restTemplate;

    public EmqxHttpClient(@Qualifier(value="emqx") @NotNull RestTemplate restTemplate) {
        Intrinsics.checkNotNullParameter((Object)restTemplate, (String)"restTemplate");
        this.restTemplate = restTemplate;
    }

    public final <T> T get$mqtt_admin_starter(@NotNull String url, @NotNull ParameterizedTypeReference<EmqxApiRequestResult<T>> typeRef2, Object ... variables) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(typeRef2, (String)"typeRef");
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        try {
            responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, HttpEntity.EMPTY, typeRef2, Arrays.copyOf(variables, variables.length));
        }
        catch (RestClientException error) {
            throw new EmqxApiException(null, Intrinsics.stringPlus((String)"Failed to call EMQ X api ", (Object)url), error, 1, null);
        }
        ResponseEntity result = responseEntity;
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        this.evaluateResult(result);
        EmqxApiRequestResult emqxApiRequestResult = (EmqxApiRequestResult)result.getBody();
        ResponseEntity responseEntity2 = responseEntity = emqxApiRequestResult == null ? null : (ResponseEntity)emqxApiRequestResult.getData();
        if (responseEntity == null) {
            throw new EmqxApiException(null, Intrinsics.stringPlus((String)"Missing response data when calling EMQ X api ", (Object)url), null, 5, null);
        }
        return (T)responseEntity;
    }

    public static /* synthetic */ Object get$mqtt_admin_starter$default(EmqxHttpClient emqxHttpClient, String string, ParameterizedTypeReference parameterizedTypeReference, Object[] objectArray, int n, Object object) {
        if ((n & 2) != 0) {
            boolean $i$f$typeRef = false;
            parameterizedTypeReference = new ParameterizedTypeReference<EmqxApiRequestResult<T>>(){};
        }
        return emqxHttpClient.get$mqtt_admin_starter(string, parameterizedTypeReference, objectArray);
    }

    public final void post$mqtt_admin_starter(@NotNull String url, @NotNull Object data, Object ... variables) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        try {
            HttpHeaders httpHeaders = new HttpHeaders();
            boolean bl = false;
            boolean bl2 = false;
            HttpHeaders $this$post_u24lambda_u2d0 = httpHeaders;
            boolean bl3 = false;
            $this$post_u24lambda_u2d0.setContentType(MediaType.APPLICATION_JSON);
            HttpHeaders headers = httpHeaders;
            HttpEntity body = new HttpEntity(data, (MultiValueMap)headers);
            boolean $i$f$typeRef = false;
            responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, body, (ParameterizedTypeReference)new ParameterizedTypeReference<EmqxApiRequestResult<Object>>(){}, Arrays.copyOf(variables, variables.length));
        }
        catch (RestClientException error) {
            throw new EmqxApiException(null, Intrinsics.stringPlus((String)"Failed to call EMQ X api ", (Object)url), error, 1, null);
        }
        ResponseEntity result = responseEntity;
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        this.evaluateResult(result);
    }

    public final void delete$mqtt_admin_starter(@NotNull String url, Object ... variables) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        try {
            boolean $i$f$typeRef = false;
            responseEntity = this.restTemplate.exchange(url, HttpMethod.DELETE, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<EmqxApiRequestResult<Object>>(){}, Arrays.copyOf(variables, variables.length));
        }
        catch (RestClientException error) {
            throw new EmqxApiException(null, Intrinsics.stringPlus((String)"Failed to call EMQ X api ", (Object)url), error, 1, null);
        }
        ResponseEntity result = responseEntity;
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        this.evaluateResult(result);
    }

    private final <T> void evaluateResult(ResponseEntity<EmqxApiRequestResult<T>> result) {
        if (result.getStatusCode() != HttpStatus.OK) {
            EmqxApiRequestResult emqxApiRequestResult;
            throw new EmqxApiException(result.getStatusCodeValue(), (emqxApiRequestResult = (EmqxApiRequestResult)result.getBody()) == null ? null : emqxApiRequestResult.getMessage(), null, 4, null);
        }
        EmqxApiRequestResult emqxApiRequestResult = (EmqxApiRequestResult)result.getBody();
        if ((emqxApiRequestResult == null ? null : emqxApiRequestResult.getCode()) == null) {
            throw new EmqxApiException(null, "Malformed response from EMQ X api", null, 4, null);
        }
        emqxApiRequestResult = (EmqxApiRequestResult)result.getBody();
        if (!(emqxApiRequestResult == null ? false : Intrinsics.areEqual((Object)emqxApiRequestResult.getCode(), (Object)0))) {
            emqxApiRequestResult = (EmqxApiRequestResult)result.getBody();
            Integer n = emqxApiRequestResult == null ? null : emqxApiRequestResult.getCode();
            emqxApiRequestResult = (EmqxApiRequestResult)result.getBody();
            throw new EmqxApiException(n, emqxApiRequestResult == null ? null : emqxApiRequestResult.getMessage(), null, 4, null);
        }
    }
}

