/*
 * Decompiled with CFR 0.152.
 */
package de.smartsquare.starter.mqttadmin.emqx;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import de.smartsquare.starter.mqttadmin.client.BrokerApiClient;
import de.smartsquare.starter.mqttadmin.emqx.EmqxApiClient;
import de.smartsquare.starter.mqttadmin.emqx.EmqxApiProperties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnProperty(value={"host"}, prefix="emqx.api")
@EnableConfigurationProperties(value={EmqxApiProperties.class})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\u0007"}, d2={"Lde/smartsquare/starter/mqttadmin/emqx/EmqxApiConfiguration;", "", "()V", "emqxApiClient", "Lde/smartsquare/starter/mqttadmin/client/BrokerApiClient;", "config", "Lde/smartsquare/starter/mqttadmin/emqx/EmqxApiProperties;", "mqtt-admin-starter"})
public class EmqxApiConfiguration {
    @Bean
    @NotNull
    public BrokerApiClient emqxApiClient(@NotNull EmqxApiProperties config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper().findAndRegisterModules().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        HttpMessageConverter[] httpMessageConverterArray = new HttpMessageConverter[]{(HttpMessageConverter)new MappingJackson2HttpMessageConverter(objectMapper)};
        RestTemplate restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).rootUri(config.getSchema() + "://" + config.getHost() + ':' + config.getPort()).basicAuthentication(config.getUsername(), config.getPassword()).messageConverters(httpMessageConverterArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)restTemplate, (String)"restTemplate");
        return new EmqxApiClient(restTemplate);
    }
}

