/*
 * Decompiled with CFR 0.152.
 */
package de.slothsoft.charts.swing;

import de.slothsoft.charts.Area;
import de.slothsoft.charts.Font;
import de.slothsoft.charts.GraphicContext;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.Objects;

public class Graphics2DGraphicContext
implements GraphicContext {
    private Graphics2D delegate;
    private Font fontAsEnum;
    private double scaleX = 1.0;
    private double scaleY = 1.0;

    public Graphics2DGraphicContext(Graphics2D graphics) {
        this.delegate = Objects.requireNonNull(graphics);
    }

    public void setColor(int color) {
        this.delegate.setColor(new Color(color, true));
    }

    public int getColor() {
        return this.delegate.getColor().getRGB();
    }

    public void setFont(Font fontAsEnum) {
        this.fontAsEnum = fontAsEnum;
        this.delegate.setFont(this.delegate.getFont().deriveFont(Graphics2DGraphicContext.createFontStyle(fontAsEnum), fontAsEnum.getSize()));
    }

    private static int createFontStyle(Font enumFont) {
        int result = 0;
        if (enumFont.isBold()) {
            result |= 1;
        }
        return result;
    }

    public Font getFont() {
        return this.fontAsEnum;
    }

    public Area calculateTextSize(String text) {
        FontMetrics fontMetrics = this.delegate.getFontMetrics();
        return new Area((double)fontMetrics.stringWidth(text), (double)fontMetrics.getHeight());
    }

    public void translate(double x, double y) {
        this.delegate.translate(x, y);
    }

    public void scale(double x, double y) {
        this.scaleX *= x;
        this.scaleY *= y;
    }

    public void clip(Area rect) {
        if (rect == null) {
            this.delegate.setClip(null);
        } else {
            this.delegate.setClip(this.convertToX(rect.getStartX()), this.convertToY(rect.getStartY()), this.convertToX(rect.calculateWidth()), this.convertToY(rect.calculateHeight()));
        }
    }

    private int convertToX(double x) {
        return (int)(this.scaleX * x);
    }

    private int convertToY(double Y) {
        return (int)(this.scaleY * Y);
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.delegate.drawLine(this.convertToX(x1), this.convertToY(y1), this.convertToX(x2), this.convertToX(y2));
    }

    public void fillRectangle(double x, double y, double width, double height) {
        this.delegate.fillRect(this.convertToX(x), this.convertToY(y), this.convertToX(width), this.convertToY(height));
    }

    public void drawPolyline(double[] x, double[] y) {
        this.delegate.drawPolyline(this.toIntArrayX(x), this.toIntArrayY(y), x.length);
    }

    private int[] toIntArrayX(double[] input) {
        int[] result = new int[input.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.convertToX(input[i]);
        }
        return result;
    }

    private int[] toIntArrayY(double[] input) {
        int[] result = new int[input.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.convertToY(input[i]);
        }
        return result;
    }

    public void fillPolygon(double[] x, double[] y) {
        this.delegate.fillPolygon(this.toIntArrayX(x), this.toIntArrayY(y), x.length);
    }

    public void drawText(double x, double y, String text) {
        this.delegate.drawString(text, this.convertToX(x), this.convertToY(y) + this.delegate.getFontMetrics().getAscent());
    }

    public void fillOval(double x, double y, double width, double height) {
        this.delegate.fillOval(this.convertToX(x), this.convertToY(y), this.convertToX(width), this.convertToY(height));
    }

    public void fillArc(double x, double y, double width, double height, double startAngle, double arcAngle) {
        this.delegate.fillArc(this.convertToX(x), this.convertToY(y), this.convertToX(width), this.convertToY(height), (int)startAngle, (int)arcAngle);
    }

    public Graphics2D getDelegate() {
        return this.delegate;
    }

    public Graphics2DGraphicContext delegate(Graphics2D newDelegate) {
        this.setDelegate(newDelegate);
        return this;
    }

    public void setDelegate(Graphics2D delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }
}

