/*
 * Decompiled with CFR 0.152.
 */
package de.slothsoft.charts.swing;

import de.slothsoft.charts.Area;
import de.slothsoft.charts.Chart;
import de.slothsoft.charts.GraphicContext;
import de.slothsoft.charts.PaintInstructions;
import de.slothsoft.charts.RefreshListener;
import de.slothsoft.charts.swing.Graphics2DGraphicContext;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class ChartControl
extends JPanel {
    private static final long serialVersionUID = -3869433809324173828L;
    private final RefreshListener refreshListener = e -> this.repaint();
    private Chart model;

    public ChartControl() {
        this((Chart)null);
    }

    public ChartControl(Chart model) {
        this.setModel(model);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.model != null) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Graphics2DGraphicContext graphicContext = new Graphics2DGraphicContext((Graphics2D)g);
            this.model.paintOn((GraphicContext)graphicContext, new PaintInstructions(new Area((double)this.getWidth(), (double)this.getHeight())));
        }
    }

    public Chart getModel() {
        return this.model;
    }

    public ChartControl model(Chart newModel) {
        this.setModel(newModel);
        return this;
    }

    public void setModel(Chart model) {
        if (this.model != null) {
            this.model.removeRefreshListener(this.refreshListener);
        }
        this.model = model;
        if (this.model != null) {
            this.model.addRefreshListener(this.refreshListener);
        }
        this.repaint();
    }
}

