/*
 * Decompiled with CFR 0.152.
 */
package de.slothsoft.charts.swing;

import de.slothsoft.charts.Area;
import de.slothsoft.charts.linechart.LineChart;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Objects;

public class MoveLineChartByMouseListener
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    static final Cursor HAND_CURSOR = new Cursor(12);
    private final LineChart chart;
    boolean mouseDown;
    private int mouseDownX;
    private int mouseDownY;
    private int movementMouseButton = 1;

    public static MoveLineChartByMouseListener hookToControl(Component control, LineChart chart) {
        MoveLineChartByMouseListener result = new MoveLineChartByMouseListener(chart);
        control.addMouseListener(result);
        control.addMouseMotionListener(result);
        control.addMouseWheelListener(result);
        return result;
    }

    public MoveLineChartByMouseListener(LineChart chart) {
        this.chart = Objects.requireNonNull(chart);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.isInGraphArea(e) && e.getButton() == this.movementMouseButton) {
            this.mouseDown = true;
            this.mouseDownX = e.getX();
            this.mouseDownY = e.getY();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == this.movementMouseButton) {
            this.mouseDown = false;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Component control = e.getComponent();
        if (this.isInGraphArea(e)) {
            control.setCursor(HAND_CURSOR);
        } else {
            control.setCursor(null);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mouseDown) {
            int diffX = this.mouseDownX - e.getX();
            int diffY = e.getY() - this.mouseDownY;
            this.chart.moveDisplayedAreaByChartCoordinates((double)diffX, (double)diffY);
            this.mouseDownX = e.getX();
            this.mouseDownY = e.getY();
        }
    }

    private boolean isInGraphArea(MouseEvent e) {
        Component control = e.getComponent();
        Dimension controlSize = control.getSize();
        Area actualArea = this.chart.calculateGraphArea(controlSize.getWidth(), controlSize.getHeight());
        return actualArea.containsPoint((double)e.getX(), (double)e.getY());
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.isInGraphArea(e)) {
            if (e.getWheelRotation() < 0) {
                this.chart.zoomDisplayedAreaInByChartCoordinates((double)e.getX(), (double)e.getY());
            } else {
                this.chart.zoomDisplayedAreaOutByChartCoordinates((double)e.getX(), (double)e.getY());
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public int getMovementMouseButton() {
        return this.movementMouseButton;
    }

    public MoveLineChartByMouseListener movementMouseButton(int newMovementMouseButton) {
        this.setMovementMouseButton(newMovementMouseButton);
        return this;
    }

    public void setMovementMouseButton(int movementMouseButton) {
        this.movementMouseButton = movementMouseButton;
    }
}

