/*
 * Decompiled with CFR 0.152.
 */
package linechart;

import de.slothsoft.charts.Area;
import de.slothsoft.charts.Chart;
import de.slothsoft.charts.linechart.DataPointLine;
import de.slothsoft.charts.linechart.FunctionLine;
import de.slothsoft.charts.linechart.LineChart;
import de.slothsoft.charts.linechart.XAxis;
import de.slothsoft.charts.linechart.YAxis;
import de.slothsoft.charts.swt.SwtChartUtil;
import java.awt.Desktop;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class LineChartExample {
    public static void main(String ... args) throws IOException {
        Chart chart = LineChartExample.createChart();
        Path imageFile = Files.createTempFile(null, ".png", new FileAttribute[0]);
        Image image = SwtChartUtil.createImage((Chart)chart, (int)600, (int)400);
        ImageLoader saver = new ImageLoader();
        saver.data = new ImageData[]{image.getImageData()};
        saver.save(imageFile.toString(), 5);
        Desktop.getDesktop().open(imageFile.toFile());
    }

    public static Chart createChart() {
        LineChart chart = new LineChart();
        chart.setBackgroundColor(-1);
        chart.setDisplayedArea(new Area(-1.0, -4.0, 10.0, 4.0));
        chart.getBorder().setSpaceOnBottom(7);
        chart.getXAxis().setPosition(XAxis.Position.Y0);
        chart.getYAxis().setPosition(YAxis.Position.X0);
        chart.getTitle().setText("Line Chart");
        chart.addLine(new DataPointLine(new double[]{-9.0, -4.0, -2.0, 0.0, 1.0, 2.0, 2.5, 3.0, 3.3, 3.6, 4.0}).color(-65281));
        chart.addLine(new FunctionLine(x -> Math.sin(x)).color(-16711936));
        return chart;
    }
}

