package de.sldw.composeonboarding.indicator

import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import de.sldw.compose_onboarding.generated.resources.Res
import de.sldw.compose_onboarding.generated.resources.onboarding_text_indicator
import org.jetbrains.compose.resources.stringResource

data class TextIndicator(
    val text: @Composable (currentPage: Int, maxPages: Int) -> String = { currentPage, maxPages ->
        stringResource(Res.string.onboarding_text_indicator, currentPage, maxPages)
    }
) : IndicatorType {
    @Composable
    override fun Content(
        currentPage: Int,
        maxPages: Int,
    ) {
        Text(
            text = text(currentPage + 1, maxPages)
        )
    }

}