package de.sldw.composeonboarding.indicator

import androidx.compose.animation.core.animateFloatAsState
import androidx.compose.animation.core.tween
import androidx.compose.material3.LinearProgressIndicator
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue

data object ProgressIndicator : IndicatorType {
    @Composable
    override fun Content(currentPage: Int, maxPages: Int) {
        val progressAnimation by animateFloatAsState(
            targetValue = (currentPage.toFloat() / (maxPages - 1).toFloat()),
            animationSpec = tween(durationMillis = 250),
            label = "progressIndicator"
        )

        LinearProgressIndicator(progress = { progressAnimation })
    }
}