package de.sldw.composeonboarding

import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.filled.NavigateBefore
import androidx.compose.material.icons.automirrored.filled.NavigateNext
import androidx.compose.material3.Icon
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import de.sldw.compose_onboarding.generated.resources.Res
import de.sldw.compose_onboarding.generated.resources.onboarding_content_description_before
import de.sldw.compose_onboarding.generated.resources.onboarding_content_description_next
import de.sldw.compose_onboarding.generated.resources.onboarding_finish
import org.jetbrains.compose.resources.stringResource

data class OnboardingButtonParams(
    val isEnabled: Boolean,
    val onClick: () -> Unit
)

@Suppress("unused")
class OnboardingSettings {
    internal var defaultPreviousButtonAccessibility: @Composable () -> String = {
        stringResource(Res.string.onboarding_content_description_before)
    }
    internal var defaultNextButtonAccessibility: @Composable () -> String = {
        stringResource(Res.string.onboarding_content_description_next)
    }
    internal var defaultFinishButtonText: @Composable () -> String = {
        stringResource(Res.string.onboarding_finish)
    }

    internal var previousButton: @Composable (OnboardingButtonParams) -> Unit = {
        TextButton(
            enabled = it.isEnabled,
            onClick = { it.onClick() }
        ) {
            Icon(
                imageVector = Icons.AutoMirrored.Default.NavigateBefore,
                contentDescription = defaultPreviousButtonAccessibility()
            )
        }
    }
    internal var nextButton: @Composable (OnboardingButtonParams) -> Unit = {
        TextButton(
            modifier = Modifier.fillMaxWidth(),
            enabled = it.isEnabled,
            onClick = { it.onClick() }
        ) {
            Icon(
                imageVector = Icons.AutoMirrored.Default.NavigateNext,
                contentDescription = defaultNextButtonAccessibility()
            )
        }
    }

    internal var finishButton: @Composable (OnboardingButtonParams) -> Unit = {
        TextButton(
            modifier = Modifier.fillMaxWidth(),
            enabled = it.isEnabled,
            onClick = { it.onClick() }
        ) {
            Text(
                maxLines = 1,
                text = defaultFinishButtonText()
            )
        }
    }

    fun setDefaultPreviousButtonAccessibility(text: @Composable () -> String) {
        defaultPreviousButtonAccessibility = text
    }

    fun setDefaultNextButtonAccessibility(text: @Composable () -> String) {
        defaultNextButtonAccessibility = text
    }

    fun setDefaultFinishButtonText(text: @Composable () -> String) {
        defaultFinishButtonText = text
    }

    fun setPreviousButton(previousButton: @Composable (OnboardingButtonParams) -> Unit) {
        this.previousButton = previousButton
    }

    fun setNextButton(nextButton: @Composable (OnboardingButtonParams) -> Unit) {
        this.nextButton = nextButton
    }

    fun setFinishButton(finishButton: @Composable (OnboardingButtonParams) -> Unit) {
        this.finishButton = finishButton
    }
}